/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.gene.editor.GeneDataEditor;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class GeneDataEditorMenuBar
extends JMenuBar {
    private GeneDataEditor editor;

    public GeneDataEditorMenuBar(GeneDataEditor editor) {
        if (editor == null) {
            throw new NullPointerException("Data editor cannot be null.");
        }
        this.editor = editor;
        this.add(this.createFileMenu());
        this.add(this.createEditMenu());
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem saveDataItem = new JMenuItem("Save Data...");
        saveDataItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataEditorMenuBar.this.saveData();
            }
        });
        menu.add(saveDataItem);
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        JMenuItem copy = new JMenuItem("Copy (Tab Delimited)");
        JMenuItem copyAsJavaArray = new JMenuItem("Copy (Java Array)");
        JMenuItem removeDiscrete = new JMenuItem("Remove Discrete Columns");
        menu.add(copy);
        menu.add(copyAsJavaArray);
        menu.add(removeDiscrete);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataEditorMenuBar.this.doCopy();
            }
        });
        copyAsJavaArray.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataEditorMenuBar.this.doCopyAsJavaArray();
            }
        });
        removeDiscrete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneDataEditorMenuBar.this.removeDiscrete();
            }
        });
        return menu;
    }

    private void saveData() {
        DataModel dataSet = this.editor.getSelectedDataSet();
        if (dataSet instanceof DataSet) {
            this.saveDataSetData();
        } else if (dataSet instanceof TimeSeriesData) {
            this.saveTimeSeriesData();
        } else {
            throw new RuntimeException();
        }
    }

    private void saveDataSetData() {
        PrintWriter out;
        File file = EditorUtils.getSaveFile("data", "dat", this.editor, false, "Save");
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        try {
            out = new PrintWriter(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Output file could not be opened: " + file);
        }
        DataSet dataSet = (DataSet)this.editor.getSelectedDataSet();
        int numVars = dataSet.getNumColumns();
        int numData = dataSet.getNumRows();
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            Node v = dataSet.getVariable(i);
            variables.add(v);
            out.print(v.getName());
            if (i >= numVars - 1) continue;
            out.print("\t");
        }
        out.println();
        for (int j = 0; j < numData; ++j) {
            for (int i = 0; i < numVars; ++i) {
                if (variables.get(i) instanceof ContinuousVariable) {
                    out.print(nf.format(dataSet.getObject(j, i)));
                } else {
                    out.print(dataSet.getObject(j, i));
                }
                if (i >= numVars - 1) continue;
                out.print("\t");
            }
            out.println();
        }
        out.close();
    }

    private void saveTimeSeriesData() {
        PrintWriter out;
        File file = EditorUtils.getSaveFile("data", "dat", this.editor, false, "Save");
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        try {
            out = new PrintWriter(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Output file could not be opened: " + file);
        }
        System.out.println(this.editor.getSelectedDataSet().getClass());
        TimeSeriesData dataSet = (TimeSeriesData)this.editor.getSelectedDataSet();
        int numVars = dataSet.getNumVars();
        int numData = dataSet.getNumTimePoints();
        List<String> vars = dataSet.getVariableNames();
        for (int i = 0; i < numVars; ++i) {
            out.print((Object)vars.get(i));
            if (i >= numVars - 1) continue;
            out.print("\t");
        }
        out.println();
        for (int j = 0; j < numData; ++j) {
            for (int i = 0; i < numVars; ++i) {
                out.print(nf.format(dataSet.getDatum(j, i)));
                if (i >= numVars - 1) continue;
                out.print("\t");
            }
            out.println();
        }
        out.close();
    }

    private void doCopy() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuilder sb = new StringBuilder();
        TimeSeriesData dataSet = (TimeSeriesData)this.editor.getSelectedDataSet();
        int numVars = dataSet.getNumVars();
        int numData = dataSet.getNumTimePoints();
        List<String> vars = dataSet.getVariableNames();
        for (int i = 0; i < numVars; ++i) {
            sb.append((Object)vars.get(i));
            if (i >= numVars - 1) continue;
            sb.append("\t");
        }
        sb.append("\n");
        for (int j = 0; j < numData; ++j) {
            for (int i = 0; i < numVars; ++i) {
                sb.append(nf.format(dataSet.getDatum(j, i)));
                if (i >= numVars - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        StringSelection strSel = new StringSelection(sb.toString());
        clip.setContents(strSel, strSel);
    }

    private void doCopyAsJavaArray() {
        DecimalFormat nf = new DecimalFormat("0.0000;-0.0000");
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuilder sb = new StringBuilder();
        TimeSeriesData dataSet = (TimeSeriesData)this.editor.getSelectedDataSet();
        int numVars = dataSet.getNumVars();
        int numData = dataSet.getNumTimePoints();
        List<String> vars = dataSet.getVariableNames();
        sb.append("\nString[] vars = {");
        for (int i = 0; i < numVars; ++i) {
            sb.append("\"");
            sb.append((Object)vars.get(i));
            sb.append("\"");
            if (i >= numVars - 1) continue;
            sb.append(", ");
        }
        sb.append("};");
        sb.append("\ndouble[][] data = {");
        for (int j = 0; j < numData; ++j) {
            sb.append("\n\t{");
            for (int i = 0; i < numVars; ++i) {
                sb.append(nf.format(dataSet.getDatum(j, i)));
                if (i >= numVars - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            if (j >= numData - 1) continue;
            sb.append(",");
        }
        sb.append("\n};\n");
        StringSelection strSel = new StringSelection(sb.toString());
        clip.setContents(strSel, strSel);
    }

    private void removeDiscrete() {
        DataSet dataSet = (DataSet)this.editor.getSelectedDataSet();
        LinkedList<Node> variables = new LinkedList<Node>(dataSet.getVariables());
        for (Node variable1 : variables) {
            if (!(variable1 instanceof DiscreteVariable)) continue;
            dataSet.removeColumn(variable1);
        }
        this.editor.getDataWrapper().setDataModel(dataSet);
        this.editor.reset();
    }
}

