/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.gene.graph.ActiveLagGraph;
import edu.cmu.tetrad.gene.graph.ManualActiveLagGraph;
import edu.cmu.tetradapp.gene.editor.DirectedGraphToolbar;
import edu.cmu.tetradapp.gene.editor.DirectedGraphWorkbench;
import edu.cmu.tetradapp.gene.editor.GraphTableWorkbench;
import edu.cmu.tetradapp.gene.editor.LagGraphTetradMenu;
import edu.cmu.tetradapp.gene.editor.LagGraphTopToolbar;
import edu.cmu.tetradapp.gene.editor.LagGraphWorkbench;
import edu.cmu.tetradapp.gene.editor.MultiGraphScrollHandler;
import edu.cmu.tetradapp.gene.editor.MultiGraphToolbar;
import edu.cmu.tetradapp.gene.editor.MultiGraphWorkbench;
import edu.cmu.tetradapp.gene.editor.TableToolbar;
import edu.cmu.tetradapp.model.RandomActiveLagGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class LagGraphEditor
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private ActiveLagGraph graphModel;
    private LagGraphWorkbench curBench;
    private DirectedGraphWorkbench directBench;
    private MultiGraphWorkbench multiBench;
    private GraphTableWorkbench tableBench;
    private JPanel benchPane;
    private JScrollPane workbenchScroll;
    private JPanel toolbar;
    private final MultiGraphScrollHandler scrollHandler = new MultiGraphScrollHandler();

    public LagGraphEditor(ManualActiveLagGraph lagGraph) {
        this.initialize(lagGraph);
    }

    public LagGraphEditor(RandomActiveLagGraph lagGraph) {
        this.initialize(lagGraph);
    }

    public void switchDirected() {
        if (this.toolbar != null) {
            this.remove(this.toolbar);
        }
        if (this.workbenchScroll != null) {
            this.benchPane.remove(this.workbenchScroll);
        }
        if (this.directBench == null) {
            this.directBench = new DirectedGraphWorkbench(this.graphModel);
        }
        this.curBench = this.directBench;
        this.workbenchScroll = new JScrollPane((JComponent)((Object)this.curBench));
        this.toolbar = new DirectedGraphToolbar(this.directBench);
        this.add((Component)this.toolbar, "West");
        this.benchPane.add((Component)this.workbenchScroll, "Center");
        this.invalidate();
        this.revalidate();
    }

    public void switchRepeating() {
        if (this.toolbar != null) {
            this.remove(this.toolbar);
        }
        if (this.workbenchScroll != null) {
            this.benchPane.remove(this.workbenchScroll);
        }
        if (this.multiBench == null) {
            this.multiBench = new MultiGraphWorkbench(this.graphModel);
        }
        this.curBench = this.multiBench;
        this.workbenchScroll = new JScrollPane(this.multiBench);
        this.workbenchScroll.getVerticalScrollBar().addAdjustmentListener(this.scrollHandler);
        this.scrollHandler.setWorkbench(this.multiBench);
        this.toolbar = new MultiGraphToolbar(this.multiBench);
        this.add((Component)this.toolbar, "West");
        this.benchPane.add((Component)this.workbenchScroll, "Center");
        this.revalidate();
        this.multiBench.scrollToHome();
    }

    public void switchTabular() {
        if (this.toolbar != null) {
            this.remove(this.toolbar);
        }
        if (this.workbenchScroll != null) {
            this.benchPane.remove(this.workbenchScroll);
        }
        if (this.tableBench == null) {
            this.tableBench = new GraphTableWorkbench(this.graphModel);
        }
        this.curBench = this.tableBench;
        this.workbenchScroll = new JScrollPane((JComponent)((Object)this.curBench));
        this.toolbar = new TableToolbar(this.tableBench);
        this.add((Component)this.toolbar, "West");
        this.benchPane.add((Component)this.workbenchScroll, "Center");
        this.invalidate();
        this.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("graph".equals(e.getPropertyName())) {
            this.graphModel = (ActiveLagGraph)e.getNewValue();
            this.firePropertyChange("graph", e.getOldValue(), e.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String text = ((AbstractButton)e.getSource()).getText();
        if (text.equals("Lag Graph")) {
            MultiGraphWorkbench multiGraphWorkbench = (MultiGraphWorkbench)this.curBench;
            multiGraphWorkbench.setEdgeDisplayMode(0);
        } else if (text.equals("Hybrid Graph")) {
            MultiGraphWorkbench multiGraphWorkbench = (MultiGraphWorkbench)this.curBench;
            multiGraphWorkbench.setEdgeDisplayMode(1);
        } else if (text.equals("Repeating Graph")) {
            MultiGraphWorkbench multiGraphWorkbench = (MultiGraphWorkbench)this.curBench;
            multiGraphWorkbench.setEdgeDisplayMode(2);
        } else if (text.equals("Multple Arrowheads")) {
            DirectedGraphWorkbench directedGraphWorkbench = (DirectedGraphWorkbench)this.curBench;
            boolean selected = ((JCheckBox)e.getSource()).isSelected();
            directedGraphWorkbench.setShowEdgeMulti(selected);
        } else if (text.equals("Numerical Label")) {
            DirectedGraphWorkbench directedGraphWorkbench = (DirectedGraphWorkbench)this.curBench;
            boolean selected = ((JCheckBox)e.getSource()).isSelected();
            directedGraphWorkbench.setShowEdgeLabels(selected);
        }
    }

    private final void initialize(ActiveLagGraph lagGraph) {
        this.setLayout(new BorderLayout());
        this.graphModel = lagGraph;
        this.benchPane = new JPanel(new BorderLayout());
        LagGraphTopToolbar tools = new LagGraphTopToolbar(this);
        this.benchPane.add((Component)tools, "North");
        this.add((Component)this.benchPane, "Center");
        LagGraphTetradMenu menu = new LagGraphTetradMenu(this);
        this.add((Component)menu, "North");
        tools.doSwitchDirected();
    }
}

