/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.LagGraphParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LagGraphParamsEditor
extends JPanel
implements ParameterEditor {
    private LagGraphParams params;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (LagGraphParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        IntTextField varsPerIndField = new IntTextField(this.getParams().getVarsPerInd(), 6);
        varsPerIndField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    LagGraphParamsEditor.this.getParams().setVarsPerInd(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        IntTextField mlagField = new IntTextField(this.getParams().getMlag(), 6);
        mlagField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    LagGraphParamsEditor.this.getParams().setMlag(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        IntTextField indegreeField = new IntTextField(this.getParams().getIndegree(), 6);
        indegreeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    LagGraphParamsEditor.this.getParams().setIndegree(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField percentUnregulatedField = new DoubleTextField(this.getParams().getPercentUnregulated(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        percentUnregulatedField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    LagGraphParamsEditor.this.getParams().setPercentUnregulated(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        JLabel l1 = new JLabel("# Vars Per Individual = ");
        JLabel l2 = new JLabel("Maximum Time Lag = ");
        String[] options = new String[]{"Constant", "Maximum", "Mean"};
        JComboBox<String> c3 = new JComboBox<String>(options);
        switch (this.getParams().getIndegreeType()) {
            case 0: {
                c3.setSelectedIndex(0);
                break;
            }
            case 1: {
                c3.setSelectedIndex(1);
                break;
            }
            case 2: {
                c3.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        c3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                int index = comboBox.getSelectedIndex();
                switch (index) {
                    case 0: {
                        LagGraphParamsEditor.this.getParams().setIndegreeType(0);
                        break;
                    }
                    case 1: {
                        LagGraphParamsEditor.this.getParams().setIndegreeType(1);
                        break;
                    }
                    case 2: {
                        LagGraphParamsEditor.this.getParams().setIndegreeType(2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        c3.setAlignmentX(1.0f);
        JLabel l3 = new JLabel(" Indegree = ");
        JLabel l4 = new JLabel("Approximate percent unregulated genes: ");
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createGlue());
        b1.add(l1);
        b1.add(varsPerIndField);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(l2);
        b2.add(mlagField);
        b.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(c3);
        b3.add(l3);
        b3.add(indegreeField);
        b.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(l4);
        b4.add(Box.createGlue());
        b4.add(percentUnregulatedField);
        b.add(b4);
        this.add(b);
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    public LagGraphParams getParams() {
        return this.params;
    }
}

