/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetradapp.gene.editor.MultiGraphNode;
import edu.cmu.tetradapp.gene.editor.MultiGraphWorkbench;
import edu.cmu.tetradapp.workbench.DisplayNode;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.JComponent;

public class TimesteppedFactor {
    protected MultiGraphWorkbench container;
    protected ArrayList pastNodes;
    protected ArrayList futureNodes;
    protected String name;
    protected Point basePosition;
    protected int stepSpacing;
    private int edgeMode = 1;
    private int timeMode = 0;

    public TimesteppedFactor(String name, MultiGraphWorkbench container, int baseX, int baseY) {
        this.container = container;
        this.name = name;
        this.setBasePosition(baseX, baseY);
        this.stepSpacing = 100;
        MultiGraphNode cur = new MultiGraphNode(this, 0);
        this.pastNodes = new ArrayList();
        this.futureNodes = new ArrayList();
        this.pastNodes.add(cur);
        this.futureNodes.add(cur);
        this.addNodeToDisplay(0);
    }

    public void setPastSteps(int pastSteps) {
        int nextTimestep = this.getPastSteps();
        while (nextTimestep < pastSteps) {
            nextTimestep = -(nextTimestep + 1);
            MultiGraphNode next = new MultiGraphNode(this, nextTimestep);
            this.pastNodes.add(next);
            this.addNodeToDisplay(nextTimestep);
            nextTimestep = this.getPastSteps();
        }
        int toRemove = this.getPastSteps();
        while (toRemove > pastSteps) {
            MultiGraphNode itm = (MultiGraphNode)this.pastNodes.remove(toRemove);
            itm.removeDisplayEdges();
            this.getContainer().unbindNode(itm);
            toRemove = this.getPastSteps();
        }
    }

    public int getPastSteps() {
        return this.pastNodes.size() - 1;
    }

    public void setFutureSteps(int futureSteps) {
        int nextTimestep = this.getFutureSteps();
        while (nextTimestep < futureSteps) {
            MultiGraphNode next = new MultiGraphNode(this, ++nextTimestep);
            this.futureNodes.add(next);
            this.addNodeToDisplay(nextTimestep);
            nextTimestep = this.getFutureSteps();
        }
        int toRemove = this.getFutureSteps();
        while (toRemove > futureSteps) {
            MultiGraphNode itm = (MultiGraphNode)this.futureNodes.remove(toRemove);
            itm.removeDisplayEdges();
            this.getContainer().unbindNode(itm);
            toRemove = this.getFutureSteps();
        }
    }

    public int getFutureSteps() {
        return this.futureNodes.size() - 1;
    }

    protected void addNodeToDisplay(int timestep) {
        Point pos = new Point(this.getBasePosition());
        pos.translate(0, timestep * this.getStepSpacing());
        MultiGraphNode itm = this.getDisplayNode(timestep);
        Dimension dim = ((JComponent)itm).getPreferredSize();
        itm.setSize(dim);
        itm.setLocation(pos.x - (dim.width >> 1), pos.y - (dim.height >> 1));
        this.getContainer().bindNode(itm);
    }

    public void synchDisplayEdges() {
        SortedSet laggedFactors = this.getContainer().getModelGraph().getParents(this.getName());
        Iterator items = this.pastNodes.iterator();
        while (items.hasNext()) {
            ((MultiGraphNode)items.next()).synchEdges(laggedFactors);
        }
        items = this.futureNodes.iterator();
        while (items.hasNext()) {
            ((MultiGraphNode)items.next()).synchEdges(laggedFactors);
        }
    }

    public void removeDisplayEdges() {
        Iterator items = this.pastNodes.iterator();
        while (items.hasNext()) {
            ((MultiGraphNode)items.next()).removeDisplayEdges();
        }
        items = this.futureNodes.iterator();
        while (items.hasNext()) {
            ((MultiGraphNode)items.next()).removeDisplayEdges();
        }
    }

    public void removeDisplayNodes() {
        MultiGraphNode itm;
        for (int toRemove = this.getPastSteps(); toRemove > 0; --toRemove) {
            itm = (MultiGraphNode)this.pastNodes.remove(toRemove);
            itm.removeDisplayEdges();
            this.getContainer().unbindNode(itm);
        }
        Iterator items = this.futureNodes.iterator();
        while (items.hasNext()) {
            itm = (MultiGraphNode)items.next();
            itm.removeDisplayEdges();
            this.getContainer().unbindNode(itm);
            items.remove();
        }
    }

    public MultiGraphNode getDisplayNode(int timestep) {
        if (timestep < 0) {
            return (MultiGraphNode)this.pastNodes.get(-timestep);
        }
        return (MultiGraphNode)this.futureNodes.get(timestep);
    }

    public int getEdgeMode() {
        return this.edgeMode;
    }

    public void setEdgeMode(int edgeMode) {
        switch (edgeMode) {
            case 0: 
            case 1: 
            case 2: {
                this.edgeMode = edgeMode;
                this.synchDisplayEdges();
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal edge mode");
            }
        }
    }

    public int getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(int timeMode) {
        switch (timeMode) {
            case 0: 
            case 1: {
                this.timeMode = timeMode;
                this.synchDisplayEdges();
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal time mode");
            }
        }
    }

    public Point getBasePosition() {
        return this.basePosition;
    }

    public void setBasePosition(int x, int y) {
        this.basePosition = new Point(x, y);
    }

    public int getStepSpacing() {
        return this.stepSpacing;
    }

    public void setStepSpacing(int stepSpacing) {
        this.stepSpacing = stepSpacing;
    }

    public MultiGraphWorkbench getContainer() {
        return this.container;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
        for (DisplayNode itm : this.pastNodes) {
            itm.setName(name);
        }
        for (DisplayNode itm : this.futureNodes) {
            itm.setName(name);
        }
    }
}

