/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeGraph;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeWorkbench;
import edu.cmu.tetradapp.util.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;

public class KnowledgeEditorToolbar
extends JPanel {
    private ButtonInfo[] buttonInfos = new ButtonInfo[]{new ButtonInfo("Select", "Select and Move", "move", "<html>Select and move nodes or groups of nodes <br>on the workbench.</html>"), new ButtonInfo("Forbidden", "Add Forbidden", "flow", "<html>Add an edge from one node to another to indicate <br>that for purposes of searches that edge will not be <br>allowed in the graph.</html>"), new ButtonInfo("Required", "Add Required", "flow", "<html>Add an edge from one node to another to indicate <br>that for purposes of searches that edge will be <br>required in the graph.</html>"), new ButtonInfo("Source Layout", "Source Layout", "flow", "<html>Lays out the nodes according to the source graph.</html>"), new ButtonInfo("Knowledge Layout", "Knowledge Layout", "flow", "<html>Lays out the nodes according to knowledge tiers.</html>")};
    private Map<JToggleButton, String> nodeTypes = new HashMap<JToggleButton, String>();
    private KnowledgeWorkbench workbench;
    private Graph sourceGraph;

    public KnowledgeEditorToolbar(KnowledgeWorkbench workbench, Graph sourceGraph) {
        int i;
        if (workbench == null) {
            throw new NullPointerException("Workbench must not be null.");
        }
        this.workbench = workbench;
        this.sourceGraph = sourceGraph;
        Box buttonsPanel = Box.createVerticalBox();
        MatteBorder insideBorder = new MatteBorder(10, 10, 10, 10, this.getBackground());
        EtchedBorder outsideBorder = new EtchedBorder();
        buttonsPanel.setBorder(new CompoundBorder(outsideBorder, insideBorder));
        JToggleButton[] buttons = new JToggleButton[this.buttonInfos.length];
        for (int i2 = 0; i2 < this.buttonInfos.length; ++i2) {
            buttons[i2] = this.constructButton(this.buttonInfos[i2]);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i3 = 0; i3 < this.buttonInfos.length; ++i3) {
            buttonGroup.add(buttons[i3]);
        }
        buttons[0].setSelected(true);
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JToggleButton component = (JToggleButton)e.getComponent();
                component.getModel().setSelected(true);
            }
        };
        for (int i4 = 0; i4 < this.buttonInfos.length; ++i4) {
            buttons[i4].addFocusListener(focusListener);
        }
        ActionListener changeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton _button = (JToggleButton)e.getSource();
                if (_button.getModel().isSelected()) {
                    KnowledgeEditorToolbar.this.setWorkbenchMode(_button);
                }
            }
        };
        for (i = 0; i < this.buttonInfos.length; ++i) {
            buttons[i].addActionListener(changeListener);
        }
        for (i = 0; i < this.buttonInfos.length; ++i) {
            buttonsPanel.add(buttons[i]);
            buttonsPanel.add(Box.createVerticalStrut(5));
        }
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(buttonsPanel, 20, 31);
        scroll.setPreferredSize(new Dimension(130, 1000));
        this.add((Component)scroll, "Center");
    }

    private JToggleButton constructButton(ButtonInfo buttonInfo) {
        String imagePrefix = buttonInfo.getImagePrefix();
        if (imagePrefix == null) {
            throw new NullPointerException("Image prefix must not be null.");
        }
        JToggleButton button = new JToggleButton();
        if ("Select".equals(buttonInfo.getNodeTypeName())) {
            button.setIcon(new ImageIcon(ImageUtils.getImage(this, "move.gif")));
        } else {
            button.setName(buttonInfo.getNodeTypeName());
            button.setText("<html><center>" + buttonInfo.getDisplayName() + "</center></html>");
        }
        button.setMaximumSize(new Dimension(100, 40));
        button.setToolTipText(buttonInfo.getToolTipText());
        this.nodeTypes.put(button, buttonInfo.getNodeTypeName());
        return button;
    }

    private void setWorkbenchMode(JToggleButton button) {
        String nodeType = this.nodeTypes.get(button);
        if ("Select".equals(nodeType)) {
            this.workbench.setWorkbenchMode(0);
        } else if ("Forbidden".equals(nodeType)) {
            this.workbench.setWorkbenchMode(2);
            this.workbench.setEdgeMode(0);
        } else if ("Required".equals(nodeType)) {
            this.workbench.setWorkbenchMode(2);
            this.workbench.setEdgeMode(2);
        } else if ("Source Layout".equals(nodeType)) {
            KnowledgeGraph graph = (KnowledgeGraph)this.workbench.getGraph();
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
            this.workbench.setGraph(graph);
        } else if ("Knowledge Layout".equals(nodeType)) {
            KnowledgeGraph graph = (KnowledgeGraph)this.workbench.getGraph();
            Knowledge knowledge = graph.getKnowledge();
            try {
                SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
                this.workbench.setGraph(graph);
            }
            catch (IllegalArgumentException ex) {
                System.out.print(ex.getMessage());
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), ex.getMessage());
            }
        }
    }

    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    private static class ButtonInfo {
        private String nodeTypeName;
        private String displayName;
        private String imagePrefix;
        private String toolTipText;

        public ButtonInfo(String nodeTypeName, String displayName, String imagePrefix, String toolTipText) {
            this.nodeTypeName = nodeTypeName;
            this.displayName = displayName;
            this.imagePrefix = imagePrefix;
            this.toolTipText = toolTipText;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setNodeTypeName(String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
        }

        public String getImagePrefix() {
            return this.imagePrefix;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }
    }
}

