/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelEdge;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelNode;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;

public class KnowledgeGraph
implements Graph,
TetradSerializableExcluded {
    static final long serialVersionUID = 23L;
    private final Graph graph = new EdgeListGraph();
    private Knowledge knowledge;

    public KnowledgeGraph(Knowledge knowledge) {
        this.setGraphConstraintsChecked(false);
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public static KnowledgeGraph serializableInstance() {
        return new KnowledgeGraph(Knowledge.serializableInstance());
    }

    @Override
    public final void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return this.getGraph().getAmbiguousTriples();
    }

    @Override
    public Set<Triple> getUnderLines() {
        return this.getGraph().getUnderLines();
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return this.getGraph().getDottedUnderlines();
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.getGraph().isAmbiguousTriple(x, y, z);
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isUnderlineTriple(x, y, z);
    }

    @Override
    public boolean isDottedUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().addAmbiguousTriple(x, y, z);
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addUnderlineTriple(x, y, z);
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().removeAmbiguousTriple(x, y, z);
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeUnderlineTriple(x, y, z);
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.getGraph().setAmbiguousTriples(triples);
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setUnderLineTriples(triples);
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setDottedUnderLineTriples(triples);
    }

    @Override
    public List<Node> getTierOrdering() {
        return this.getGraph().getTierOrdering();
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.getGraph().fullyConnect(endpoint);
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        this.getGraph().reorientAllWith(endpoint);
    }

    @Override
    public Endpoint[][] getEndpointMatrix() {
        return this.getGraph().getEndpointMatrix();
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.removeEdge(this.getEdge(node1, node2));
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.getGraph().removeEdges(node1, node2);
    }

    @Override
    public boolean isAdjacentTo(Node nodeX, Node nodeY) {
        return this.getGraph().isAdjacentTo(nodeX, nodeY);
    }

    @Override
    public boolean setEndpoint(Node node1, Node node2, Endpoint endpoint) {
        return this.getGraph().setEndpoint(node1, node2, endpoint);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getGraph()).equals(o);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean existsUndirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsUndirectedPathFromTo(node1, node2);
    }

    public boolean existsSemiDirectedPathFromTo(Node node1, Set node2) {
        return this.getGraph().existsSemiDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean addDirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addUndirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNondirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addBidirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(Edge edge) {
        if (!(edge instanceof KnowledgeModelEdge)) {
            return false;
        }
        KnowledgeModelEdge _edge = (KnowledgeModelEdge)edge;
        KnowledgeModelNode _node1 = (KnowledgeModelNode)_edge.getNode1();
        KnowledgeModelNode _node2 = (KnowledgeModelNode)_edge.getNode2();
        String from = _node1.getName();
        String to = _node2.getName();
        if (_edge.getType() == 0) {
            this.knowledge.setEdgeForbidden(from, to, true);
        } else if (_edge.getType() == 2) {
            this.knowledge.setEdgeRequired(from, to, true);
        } else if (_edge.getType() == 1) {
            if (!this.knowledge.isForbiddenByTiers(from, to)) {
                throw new IllegalArgumentException("Edge " + from + "-->" + to + " is not forbidden by tiers.");
            }
        } else if (_edge.getType() == 3) {
            if (!this.knowledge.edgeForbiddenByGroups(from, to)) {
                throw new IllegalArgumentException("Edge " + from + "-->" + to + " is not forbidden by groups.");
            }
        } else if (_edge.getType() == 4 && !this.knowledge.edgeRequiredByGroups(from, to)) {
            throw new IllegalArgumentException("Edge " + from + "-->" + to + " is not required by groups.");
        }
        return this.getGraph().addEdge(edge);
    }

    @Override
    public boolean addNode(Node node) {
        return this.getGraph().addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public List<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public List<GraphConstraint> getGraphConstraints() {
        return this.getGraph().getGraphConstraints();
    }

    @Override
    public boolean isGraphConstraintsChecked() {
        return this.getGraph().isGraphConstraintsChecked();
    }

    @Override
    public void setGraphConstraintsChecked(boolean checked) {
        this.getGraph().setGraphConstraintsChecked(checked);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        KnowledgeModelEdge _edge = (KnowledgeModelEdge)edge;
        KnowledgeModelNode _node1 = (KnowledgeModelNode)_edge.getNode1();
        KnowledgeModelNode _node2 = (KnowledgeModelNode)_edge.getNode2();
        String from = _node1.getName();
        String to = _node2.getName();
        if (_edge.getType() == 0) {
            this.getKnowledge().setEdgeForbidden(from, to, false);
        } else if (_edge.getType() == 2) {
            this.getKnowledge().setEdgeRequired(from, to, false);
        } else {
            if (_edge.getType() == 1) {
                throw new IllegalArgumentException("Please use the tiers interface to remove edges forbidden by tiers.");
            }
            if (_edge.getType() == 3) {
                throw new IllegalArgumentException("Please use the Other Groups interface to remove edges forbidden by groups.");
            }
            if (_edge.getType() == 4) {
                throw new IllegalArgumentException("Please use the Other Groups interface to remove edges required by groups.");
            }
        }
        return this.getGraph().removeEdge(edge);
    }

    public boolean removeEdges(List edges) {
        boolean removed = false;
        for (Object edge1 : edges) {
            Edge edge = (Edge)edge1;
            removed = removed || this.removeEdge(edge);
        }
        return removed;
    }

    @Override
    public boolean removeNode(Node node) {
        return this.getGraph().removeNode(node);
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean existsDirectedCycle() {
        return this.getGraph().existsDirectedCycle();
    }

    @Override
    public boolean isDirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isDirectedFromTo(node1, node2);
    }

    @Override
    public boolean isUndirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isUndirectedFromTo(node1, node2);
    }

    @Override
    public boolean defVisible(Edge edge) {
        return this.getGraph().defVisible(edge);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean existsTrek(Node node1, Node node2) {
        return this.getGraph().existsTrek(node1, node2);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getConnectivity() {
        return this.getGraph().getConnectivity();
    }

    @Override
    public List<Node> getDescendants(List<Node> nodes) {
        return this.getGraph().getDescendants(nodes);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public boolean isAncestorOf(Node node1, Node node2) {
        return this.getGraph().isAncestorOf(node1, node2);
    }

    @Override
    public boolean possibleAncestor(Node node1, Node node2) {
        return this.getGraph().possibleAncestor(node1, node2);
    }

    @Override
    public List<Node> getAncestors(List<Node> nodes) {
        return this.getGraph().getAncestors(nodes);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isDescendentOf(Node node1, Node node2) {
        return this.getGraph().isDescendentOf(node1, node2);
    }

    @Override
    public boolean defNonDescendent(Node node1, Node node2) {
        return this.getGraph().defNonDescendent(node1, node2);
    }

    @Override
    public boolean isDConnectedTo(Node node1, Node node2, List<Node> conditioningNodes) {
        return this.getGraph().isDConnectedTo(node1, node2, conditioningNodes);
    }

    @Override
    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return this.getGraph().isDSeparatedFrom(node1, node2, z);
    }

    @Override
    public boolean possDConnectedTo(Node node1, Node node2, List<Node> z) {
        return this.getGraph().possDConnectedTo(node1, node2, z);
    }

    @Override
    public boolean existsInducingPath(Node node1, Node node2, Set<Node> observedNodes, Set<Node> conditioningNodes) {
        return this.getGraph().existsInducingPath(node1, node2, observedNodes, conditioningNodes);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isProperAncestorOf(Node node1, Node node2) {
        return this.getGraph().isProperAncestorOf(node1, node2);
    }

    @Override
    public boolean isProperDescendentOf(Node node1, Node node2) {
        return this.getGraph().isProperDescendentOf(node1, node2);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public String toString() {
        return ((Object)this.getGraph()).toString();
    }

    @Override
    public boolean addGraphConstraint(GraphConstraint gc) {
        return this.getGraph().addGraphConstraint(gc);
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    private Graph getGraph() {
        return this.graph;
    }
}

