/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import java.beans.PropertyChangeListener;

public class KnowledgeModelNode
implements Node,
TetradSerializableExcluded {
    static final long serialVersionUID = 23L;
    private String name;
    private int centerX;
    private int centerY;

    public KnowledgeModelNode(String varName) {
        if (varName == null) {
            throw new NullPointerException();
        }
        this.name = varName;
    }

    public KnowledgeModelNode(KnowledgeModelNode node) {
        this.name = node.name;
        this.centerX = node.centerX;
        this.centerY = node.centerY;
    }

    public static KnowledgeModelNode serializableInstance() {
        return new KnowledgeModelNode("X");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NO_TYPE;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCenterX() {
        return this.centerX;
    }

    @Override
    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public int getCenterY() {
        return this.centerY;
    }

    @Override
    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public void setCenter(int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

