/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.BayesDataParams;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;

public class BayesDataWrapper
extends DataWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesIm bayesIm = null;

    public BayesDataWrapper(BayesImWrapper wrapper, BayesDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isLatentDataSaved();
        this.setDataModel(wrapper.getBayesIm().simulateData(sampleSize, latentDataSaved));
        this.setSourceGraph(wrapper.getBayesIm().getDag());
        this.bayesIm = wrapper.getBayesIm();
        this.setParams(params);
        LogObjectsUtils.logDataModelList("Data simulated from a Bayes net.", this.getDataModelList());
    }

    public BayesDataWrapper(BayesPmWrapper wrapper) {
        this.setSourceGraph(wrapper.getBayesPm().getDag());
        this.setKnownVariables(wrapper.getBayesPm().getVariables());
        LogObjectsUtils.logDataModelList("Data simulated from a Bayes net.", this.getDataModelList());
    }

    public BayesDataWrapper(BayesEstimatorWrapper wrapper, BayesDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isLatentDataSaved();
        this.setDataModel(wrapper.getEstimatedBayesIm().simulateData(sampleSize, latentDataSaved));
        this.setSourceGraph(wrapper.getEstimatedBayesIm().getDag());
        this.bayesIm = wrapper.getEstimatedBayesIm();
        this.setParams(params);
        LogObjectsUtils.logDataModelList("Data simulated from a Bayes net.", this.getDataModelList());
    }

    public BayesDataWrapper(DirichletEstimatorWrapper wrapper, BayesDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isLatentDataSaved();
        this.setDataModel(wrapper.getEstimatedBayesIm().simulateData(sampleSize, latentDataSaved));
        this.setSourceGraph(wrapper.getEstimatedBayesIm().getDag());
        this.bayesIm = wrapper.getEstimatedBayesIm();
        this.setParams(params);
        LogObjectsUtils.logDataModelList("Data simulated from a Bayes net.", this.getDataModelList());
    }

    public BayesDataWrapper(CptInvariantUpdaterWrapper wrapper, BayesDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isLatentDataSaved();
        this.setDataModel(wrapper.getBayesUpdater().getUpdatedBayesIm().simulateData(sampleSize, latentDataSaved));
        this.setSourceGraph(wrapper.getBayesUpdater().getUpdatedBayesIm().getDag());
        this.bayesIm = wrapper.getBayesUpdater().getUpdatedBayesIm();
        this.setParams(params);
        LogObjectsUtils.logDataModelList("Data simulated from a Bayes net.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new BayesDataWrapper(BayesPmWrapper.serializableInstance());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Params getParams() {
        return super.getParams();
    }

    public BayesIm getBayesIm() {
        return this.bayesIm;
    }
}

