/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.ApproximateUpdaterWrapper;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImParams;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.RowSummingExactWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class BayesImWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesIm bayesIm;

    public BayesImWrapper(BayesPmWrapper bayesPmWrapper, BayesImWrapper oldBayesImwrapper, BayesImParams params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        BayesIm oldBayesIm = oldBayesImwrapper.getBayesIm();
        if (params.getInitializationMode() == 0) {
            this.bayesIm = new MlBayesIm(bayesPm, oldBayesIm, 0);
        } else if (params.getInitializationMode() == 1) {
            this.bayesIm = new MlBayesIm(bayesPm, oldBayesIm, 1);
        } else if (params.getInitializationMode() == 2) {
            this.bayesIm = new MlBayesIm(bayesPm, 1);
        }
        this.log(this.bayesIm);
    }

    public BayesImWrapper(BayesEstimatorWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = wrapper.getEstimatedBayesIm();
        this.log(this.bayesIm);
    }

    public BayesImWrapper(DirichletEstimatorWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = wrapper.getEstimatedBayesIm();
        this.log(this.bayesIm);
    }

    public BayesImWrapper(DirichletBayesImWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = new MlBayesIm(wrapper.getDirichletBayesIm());
        this.log(this.bayesIm);
    }

    public BayesImWrapper(RowSummingExactWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = wrapper.getBayesUpdater().getUpdatedBayesIm();
        this.log(this.bayesIm);
    }

    public BayesImWrapper(CptInvariantUpdaterWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = wrapper.getBayesUpdater().getUpdatedBayesIm();
        this.log(this.bayesIm);
    }

    public BayesImWrapper(ApproximateUpdaterWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = wrapper.getBayesUpdater().getUpdatedBayesIm();
        this.log(this.bayesIm);
    }

    public BayesImWrapper(BayesPmWrapper bayesPmWrapper, BayesImParams params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        if (params.getInitializationMode() == 0) {
            this.bayesIm = new MlBayesIm(bayesPm);
        } else if (params.getInitializationMode() == 1) {
            this.bayesIm = new MlBayesIm(bayesPm, 1);
        } else if (params.getInitializationMode() == 2) {
            this.bayesIm = new MlBayesIm(bayesPm, 1);
        }
        this.log(this.bayesIm);
    }

    public BayesImWrapper(BayesImWrapper bayesImWrapper) {
        if (bayesImWrapper == null) {
            throw new NullPointerException();
        }
        this.bayesIm = new MlBayesIm(bayesImWrapper.getBayesIm());
        this.log(this.bayesIm);
    }

    public static BayesImWrapper serializableInstance() {
        return new BayesImWrapper(BayesPmWrapper.serializableInstance(), BayesImParams.serializableInstance());
    }

    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    @Override
    public Graph getGraph() {
        return this.bayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(BayesIm im) {
        TetradLogger.getInstance().log("info", "Maximum likelihood Bayes IM");
        TetradLogger.getInstance().log("im", ((Object)im).toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

