/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.model.Params;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BayesPmParams
implements Params {
    static final long serialVersionUID = 23L;
    public static final int MANUAL = 0;
    public static final int AUTOMATIC = 1;
    private int initializationMode = 0;
    private int lowerBoundNumVals = 2;
    private int upperBoundNumVals = 4;

    public static BayesPmParams serializableInstance() {
        return new BayesPmParams();
    }

    public int getLowerBoundNumVals() {
        return this.lowerBoundNumVals;
    }

    public void setLowerBoundNumVals(int lowerBoundNumVals) {
        if (lowerBoundNumVals < 2) {
            throw new IllegalArgumentException("Number of values must be >= 2: " + lowerBoundNumVals);
        }
        if (lowerBoundNumVals > this.upperBoundNumVals) {
            throw new IllegalArgumentException("Lower bound must be <= upper bound.");
        }
        this.lowerBoundNumVals = lowerBoundNumVals;
    }

    public int getUpperBoundNumVals() {
        return this.upperBoundNumVals;
    }

    public void setUpperBoundNumVals(int upperBoundNumVals) {
        if (upperBoundNumVals < 2) {
            throw new IllegalArgumentException("Number of values must be >= 2: " + upperBoundNumVals);
        }
        if (upperBoundNumVals < this.lowerBoundNumVals) {
            throw new IllegalArgumentException("Upper bound must be >= lower bound.");
        }
        this.upperBoundNumVals = upperBoundNumVals;
    }

    public int getInitializationMode() {
        return this.initializationMode;
    }

    public void setInitializationMode(int initializationMode) {
        if (initializationMode != 0 && initializationMode != 1) {
            throw new IllegalArgumentException("Initialization mode must be MANUAL or AUTOMATIC.");
        }
        this.initializationMode = initializationMode;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        switch (this.initializationMode) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Illegal value: " + this.initializationMode);
            }
        }
        if (this.lowerBoundNumVals < 2) {
            throw new IllegalStateException("LowerBoundNumVals out of range: " + this.lowerBoundNumVals);
        }
        if (this.lowerBoundNumVals > this.upperBoundNumVals) {
            throw new IllegalStateException("LowerBoundNumVals > upperBoundNumVals: " + this.lowerBoundNumVals + " > " + this.upperBoundNumVals);
        }
    }
}

