/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.BayesDataWrapper;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmParams;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GeneSimDataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.SemDataWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BayesPmWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesPm bayesPm;

    public BayesPmWrapper(Dag graph, BayesPmParams params) {
        int lowerBound;
        int upperBound;
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (params.getInitializationMode() == 0) {
            upperBound = 2;
            lowerBound = 2;
        } else if (params.getInitializationMode() == 1) {
            lowerBound = params.getLowerBoundNumVals();
            upperBound = params.getUpperBoundNumVals();
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
        this.bayesPm = new BayesPm(graph, lowerBound, upperBound);
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(Dag graph, BayesPm bayesPm, BayesPmParams params) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (bayesPm == null) {
            throw new NullPointerException("BayesPm must not be null");
        }
        if (params.getInitializationMode() == 0) {
            int upperBound = 2;
            int lowerBound = 2;
            this.bayesPm = new BayesPm(graph, bayesPm, lowerBound, upperBound);
        } else if (params.getInitializationMode() == 1) {
            int lowerBound = params.getLowerBoundNumVals();
            int upperBound = params.getUpperBoundNumVals();
            this.bayesPm = new BayesPm(graph, lowerBound, upperBound);
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
        this.log(bayesPm);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, BayesPmParams params) {
        int lowerBound;
        int upperBound;
        Dag graph;
        if (graphWrapper == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        try {
            graph = new Dag(graphWrapper.getGraph());
        }
        catch (Exception e) {
            throw new RuntimeException("The parent graph cannot be converted to a DAG.");
        }
        if (params.getInitializationMode() == 0) {
            upperBound = 2;
            lowerBound = 2;
        } else if (params.getInitializationMode() == 1) {
            lowerBound = params.getLowerBoundNumVals();
            upperBound = params.getUpperBoundNumVals();
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
        this.bayesPm = new BayesPm(graph, lowerBound, upperBound);
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, BayesPmWrapper oldBayesPmWrapper, BayesPmParams params) {
        block6: {
            try {
                if (graphWrapper == null) {
                    throw new NullPointerException("Graph must not be null.");
                }
                if (oldBayesPmWrapper == null) {
                    throw new NullPointerException("BayesPm must not be null");
                }
                Dag graph = new Dag(graphWrapper.getGraph());
                if (params.getInitializationMode() == 0) {
                    int upperBound = 2;
                    int lowerBound = 2;
                    this.bayesPm = new BayesPm(graph, oldBayesPmWrapper.getBayesPm(), lowerBound, upperBound);
                    break block6;
                }
                if (params.getInitializationMode() == 1) {
                    int lowerBound = params.getLowerBoundNumVals();
                    int upperBound = params.getUpperBoundNumVals();
                    this.bayesPm = new BayesPm(graph, lowerBound, upperBound);
                    break block6;
                }
                throw new IllegalStateException("Unrecognized type.");
            }
            catch (Exception e) {
                throw new RuntimeException("The parent graph cannot be converted to a DAG.");
            }
        }
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(BayesEstimatorWrapper wrapper) {
        this.bayesPm = new BayesPm(wrapper.getEstimatedBayesIm().getBayesPm());
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(BayesImWrapper wrapper) {
        this.bayesPm = new BayesPm(wrapper.getBayesIm().getBayesPm());
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, DataWrapper dataWrapper) {
        this(new Dag(graphWrapper.getGraph()), dataWrapper);
    }

    public BayesPmWrapper(Dag graph, DataWrapper dataWrapper) {
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        List<Node> vars = dataSet.getVariables();
        HashMap<String, DiscreteVariable> nodesToVars = new HashMap<String, DiscreteVariable>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            DiscreteVariable var = (DiscreteVariable)vars.get(i);
            String name = var.getName();
            Node node = new GraphNode(name);
            nodesToVars.put(node.getName(), var);
        }
        BayesPm bayesPm = new BayesPm(graph);
        List<Node> nodes = bayesPm.getDag().getNodes();
        for (Node node : nodes) {
            Node var = (Node)nodesToVars.get(node.getName());
            if (!(var instanceof DiscreteVariable)) continue;
            DiscreteVariable var2 = (DiscreteVariable)nodesToVars.get(node.getName());
            int numCategories = var2.getNumCategories();
            ArrayList<String> categories = new ArrayList<String>();
            for (int j = 0; j < numCategories; ++j) {
                categories.add(var2.getCategory(j));
            }
            bayesPm.setCategories(node, categories);
        }
        this.bayesPm = bayesPm;
        this.log(bayesPm);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, BayesDataWrapper dataWrapper) {
        this(graphWrapper, (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, SemDataWrapper dataWrapper) {
        this(graphWrapper, (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, GeneSimDataWrapper dataWrapper) {
        this(graphWrapper, (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, BayesPmParams params) {
        this(new Dag(wrapper.getResultGraph()), params);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, DataWrapper dataWrapper) {
        this(new Dag(wrapper.getResultGraph()), dataWrapper);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, BayesDataWrapper dataWrapper) {
        this(new Dag(wrapper.getResultGraph()), (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, SemDataWrapper dataWrapper) {
        this(new Dag(wrapper.getResultGraph()), (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, GeneSimDataWrapper dataWrapper) {
        this(new Dag(wrapper.getResultGraph()), (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(BayesEstimatorWrapper wrapper, BayesDataWrapper dataWrapper) {
        this(new Dag(wrapper.getGraph()), (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(BayesEstimatorWrapper wrapper, DataWrapper dataWrapper) {
        this(new Dag(wrapper.getGraph()), dataWrapper);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, BayesPmParams params) {
        int lowerBound;
        int upperBound;
        Dag graph;
        if (dagWrapper == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        try {
            graph = new Dag(dagWrapper.getDag());
        }
        catch (Exception e) {
            throw new RuntimeException("The parent graph cannot be converted to a DAG.");
        }
        if (params.getInitializationMode() == 0) {
            upperBound = 2;
            lowerBound = 2;
        } else if (params.getInitializationMode() == 1) {
            lowerBound = params.getLowerBoundNumVals();
            upperBound = params.getUpperBoundNumVals();
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
        this.bayesPm = new BayesPm(graph, lowerBound, upperBound);
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, BayesPmWrapper oldBayesPmWrapper, BayesPmParams params) {
        block6: {
            try {
                if (dagWrapper == null) {
                    throw new NullPointerException("Graph must not be null.");
                }
                if (oldBayesPmWrapper == null) {
                    throw new NullPointerException("BayesPm must not be null");
                }
                Dag graph = new Dag(dagWrapper.getDag());
                if (params.getInitializationMode() == 0) {
                    int upperBound = 2;
                    int lowerBound = 2;
                    this.bayesPm = new BayesPm(graph, oldBayesPmWrapper.getBayesPm(), lowerBound, upperBound);
                    break block6;
                }
                if (params.getInitializationMode() == 1) {
                    int lowerBound = params.getLowerBoundNumVals();
                    int upperBound = params.getUpperBoundNumVals();
                    this.bayesPm = new BayesPm(graph, lowerBound, upperBound);
                    break block6;
                }
                throw new IllegalStateException("Unrecognized type.");
            }
            catch (Exception e) {
                throw new RuntimeException("The parent graph cannot be converted to a DAG.");
            }
        }
        this.log(this.bayesPm);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, DataWrapper dataWrapper) {
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        List<Node> vars = dataSet.getVariables();
        HashMap<String, DiscreteVariable> nodesToVars = new HashMap<String, DiscreteVariable>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            DiscreteVariable var = (DiscreteVariable)vars.get(i);
            String name = var.getName();
            GraphNode node = new GraphNode(name);
            nodesToVars.put(node.getName(), var);
        }
        Dag graph = new Dag(dagWrapper.getDag());
        BayesPm bayesPm = new BayesPm(graph);
        List<Node> nodes = bayesPm.getDag().getNodes();
        for (Node node : nodes) {
            Node var = (Node)nodesToVars.get(node.getName());
            if (!(var instanceof DiscreteVariable)) continue;
            DiscreteVariable var2 = (DiscreteVariable)nodesToVars.get(node.getName());
            int numCategories = var2.getNumCategories();
            ArrayList<String> categories = new ArrayList<String>();
            for (int j = 0; j < numCategories; ++j) {
                categories.add(var2.getCategory(j));
            }
            bayesPm.setCategories(node, categories);
        }
        this.bayesPm = bayesPm;
        this.log(bayesPm);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, BayesDataWrapper dataWrapper) {
        this(dagWrapper, (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, SemDataWrapper dataWrapper) {
        this(dagWrapper, (DataWrapper)dataWrapper);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, GeneSimDataWrapper dataWrapper) {
        this(dagWrapper, (DataWrapper)dataWrapper);
    }

    public static BayesPmWrapper serializableInstance() {
        return new BayesPmWrapper(Dag.serializableInstance(), BayesPmParams.serializableInstance());
    }

    public BayesPm getBayesPm() {
        return this.bayesPm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesPm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.bayesPm.getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(BayesPm pm) {
        TetradLogger.getInstance().log("info", "Bayes Parametric Model (Bayes PM)");
        TetradLogger.getInstance().log("pm", pm.toString());
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

