/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class CompletedPatternWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private Graph graph;

    public CompletedPatternWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        graph = new EdgeListGraph(graph);
        SearchGraphUtils.basicPattern(graph);
        MeekRules rules = new MeekRules();
        rules.setKnowledge(new Knowledge());
        rules.orientImplied(graph);
        this.graph = graph;
    }

    public CompletedPatternWrapper(GraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public CompletedPatternWrapper(DagWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public CompletedPatternWrapper(SemGraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public static CompletedPatternWrapper serializableInstance() {
        return new CompletedPatternWrapper(Dag.serializableInstance());
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.graph == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

