/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.CcdRunner;
import edu.cmu.tetradapp.model.CeFanSearchRunner;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.FciRunnerOld;
import edu.cmu.tetradapp.model.GesRunner;
import edu.cmu.tetradapp.model.GraphParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.MbfsRunner;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.PurifyRunner;
import edu.cmu.tetradapp.model.RegressionRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.prefs.Preferences;

public class DagWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private Dag dag;

    public DagWrapper(Dag graph) {
        if (graph == null) {
            throw new NullPointerException("Tetrad dag must not be null.");
        }
        this.dag = graph;
        this.log();
    }

    public DagWrapper(GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.dag = new Dag();
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public DagWrapper(DagWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.dag = new Dag(graphWrapper.getDag());
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public DagWrapper(SemGraphWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.dag = new Dag(graphWrapper.getSemGraph());
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public DagWrapper(GraphWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.dag = new Dag(graphWrapper.getGraph());
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public DagWrapper(AbstractAlgorithmRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(PcRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(FciRunnerOld wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(CcdRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(GesRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(MimBuildRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(PurifyRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(BuildPureClustersRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(MbfsRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(CeFanSearchRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(DataWrapper wrapper) {
        this(new Dag(new EdgeListGraph(wrapper.getVariables())));
        GraphUtils.arrangeInCircle(this.dag, 200, 200, 150);
    }

    public DagWrapper(BayesPmWrapper wrapper) {
        this(new Dag(wrapper.getBayesPm().getDag()));
    }

    public DagWrapper(BayesImWrapper wrapper) {
        this(new Dag(wrapper.getBayesIm().getBayesPm().getDag()));
    }

    public DagWrapper(BayesEstimatorWrapper wrapper) {
        this(new Dag(wrapper.getEstimatedBayesIm().getBayesPm().getDag()));
    }

    public DagWrapper(CptInvariantUpdaterWrapper wrapper) {
        this(new Dag(wrapper.getBayesUpdater().getManipulatedGraph()));
    }

    public DagWrapper(SemPmWrapper wrapper) {
        this(new Dag(wrapper.getSemPm().getGraph()));
    }

    public DagWrapper(SemImWrapper wrapper) {
        this(new Dag(wrapper.getSemIm().getSemPm().getGraph()));
    }

    public DagWrapper(SemEstimatorWrapper wrapper) {
        this(new Dag(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph()));
    }

    public DagWrapper(RegressionRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public static DagWrapper serializableInstance() {
        return new DagWrapper(Dag.serializableInstance());
    }

    public Dag getDag() {
        return this.dag;
    }

    public void setDag(Dag graph) {
        this.dag = graph;
        this.log();
    }

    private void log() {
        TetradLogger.getInstance().log("info", "Directed Acyclic Graph (DAG)");
        TetradLogger.getInstance().log("graph", this.dag + "");
    }

    private void createRandomDag() {
        boolean uniformlySelected = Preferences.userRoot().getBoolean("graphUniformlySelected", true);
        int numMeasuredNodes = Preferences.userRoot().getInt("newGraphNumMeasuredNodes", 5);
        int numLatents = Preferences.userRoot().getInt("newGraphNumLatents", 0);
        int newGraphNumEdges = Preferences.userRoot().getInt("newGraphNumEdges", 3);
        boolean connected = Preferences.userRoot().getBoolean("randomGraphConnected", false);
        if (uniformlySelected) {
            int maxDegree = Preferences.userRoot().getInt("randomGraphMaxDegree", 6);
            int maxIndegree = Preferences.userRoot().getInt("randomGraphMaxIndegree", 3);
            int maxOutdegree = Preferences.userRoot().getInt("randomGraphMaxOutdegree", 3);
            this.dag = GraphUtils.randomDag(numMeasuredNodes + numLatents, numLatents, newGraphNumEdges, maxDegree, maxIndegree, maxOutdegree, connected);
        } else {
            do {
                this.dag = GraphUtils.randomDag(numMeasuredNodes + numLatents, numLatents, newGraphNumEdges, 30, 15, 15, connected);
            } while (this.dag.getNumEdges() < newGraphNumEdges);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dag == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.dag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

