/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BootstrapSampler;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DiscreteBootstrapSamplerParams;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DiscreteBootstrapSamplerWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private DataSet outputDataSet;

    public DiscreteBootstrapSamplerWrapper(DataWrapper wrapper, DiscreteBootstrapSamplerParams params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)wrapper.getSelectedDataModel();
        BootstrapSampler sampler = new BootstrapSampler();
        this.outputDataSet = sampler.sample(dataSet, params.getSampleSize());
        this.setDataModel(this.outputDataSet);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogObjectsUtils.logDataModelList("Bootstrap sample from a discrete dataset.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new DiscreteBootstrapSamplerWrapper(DataWrapper.serializableInstance(), DiscreteBootstrapSamplerParams.serializableInstance());
    }

    public DataSet getOutputDataset() {
        return this.outputDataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.outputDataSet == null) {
            throw new NullPointerException();
        }
    }
}

