/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class EditorUtils {
    public static Point getTopLeftPoint(List modelElements) {
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        for (Object modelElement : modelElements) {
            if (!(modelElement instanceof SessionNodeWrapper)) continue;
            int _x = ((SessionNodeWrapper)modelElement).getCenterX();
            int _y = ((SessionNodeWrapper)modelElement).getCenterY();
            if (_x < x) {
                x = _x;
            }
            if (_y >= y) continue;
            y = _y;
        }
        return new Point(x, y);
    }

    public static File nextFile(String _directory, String prefix, String suffix, boolean overwrite) {
        String name;
        boolean success;
        File directory;
        if (prefix.endsWith(suffix)) {
            prefix = prefix.substring(0, prefix.lastIndexOf(46));
        }
        if (!(directory = new File(_directory)).exists() && !(success = directory.mkdir())) {
            return null;
        }
        if (overwrite) {
            return new File(directory, prefix + "." + suffix);
        }
        List<String> files = Arrays.asList(directory.list());
        int i = 0;
        while (files.contains(name = prefix + ++i + "." + suffix)) {
        }
        return new File(directory, name);
    }

    public static File ensureSuffix(File file, String suffix) {
        String fileName = file.getName();
        if (!fileName.endsWith(suffix)) {
            fileName = fileName + "." + suffix;
            return new File(file.getParent(), fileName);
        }
        return file;
    }

    public static File getSaveFile(String prefix, String suffix, Component parent, boolean overwrite, String dialogName) {
        int ret2;
        File outfile;
        JFileChooser chooser = EditorUtils.createJFileChooser(dialogName);
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", Preferences.userRoot().absolutePath());
        File dir = new File(sessionSaveLocation);
        chooser.setCurrentDirectory(dir);
        chooser.setFileSelectionMode(0);
        File selectedFile = EditorUtils.nextFile(sessionSaveLocation, prefix, suffix, overwrite);
        chooser.setSelectedFile(selectedFile);
        do {
            int ret;
            if ((ret = chooser.showSaveDialog(parent)) == -1) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There was an error in choosing the file.");
                return null;
            }
            if (ret != 1) continue;
            return null;
        } while ((outfile = chooser.getSelectedFile()).exists() && (ret2 = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Overwrite existing file?")) != 0);
        outfile = EditorUtils.ensureSuffix(outfile, suffix);
        Preferences.userRoot().put("fileSaveLocation", outfile.getParent());
        return outfile;
    }

    public static JFileChooser createJFileChooser(String name) {
        if (name == null) {
            name = "Save";
        }
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(name);
        return chooser;
    }
}

