/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BidirectedToUndirectedWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;

public class ExtractMarkovBlanketWrapper
extends GraphWrapper {
    static final long serialVersionUID = 23L;

    public ExtractMarkovBlanketWrapper(GraphSource source) {
        this(source.getGraph());
    }

    public ExtractMarkovBlanketWrapper(Graph graph) {
        super(new EdgeListGraph(), "Extract Markov Blanket");
        String targetName = this.getVariableName(graph);
        Graph mb = this.getMb(graph, targetName);
        super.setGraph(mb);
        TetradLogger.getInstance().log("graph", "\nMarkov blanket for variable '" + targetName + "':");
        TetradLogger.getInstance().log("graph", this.getGraph() + "");
    }

    public static BidirectedToUndirectedWrapper serializableInstance() {
        return new BidirectedToUndirectedWrapper(EdgeListGraph.serializableInstance());
    }

    private Graph getMb(Graph graph, String target) {
        if (target == null) {
            return new EdgeListGraph();
        }
        EdgeListGraph mb = new EdgeListGraph(graph);
        Node _target = mb.getNode(target);
        MbUtils.trimToMbNodes(mb, _target, false);
        MbUtils.trimEdgesAmongParents(mb, _target);
        MbUtils.trimEdgesAmongParentsOfChildren(mb, _target);
        System.out.println("MB # nodes = " + mb.getNumNodes());
        return mb;
    }

    private String getVariableName(Graph graph) {
        Box box = Box.createVerticalBox();
        List<Node> nodes = graph.getNodes();
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (Node node : nodes) {
            nodeNames.add(node.getName());
        }
        if (nodeNames.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There are no nodes in the graph.");
            return null;
        }
        JComboBox<Object> comboBox = new JComboBox<Object>(nodeNames.toArray());
        String savedNode = Preferences.userRoot().get("mbSavedNode", (String)nodeNames.get(0));
        if (nodeNames.contains(savedNode)) {
            comboBox.setSelectedItem(savedNode);
        }
        box.add(comboBox);
        box.add(Box.createVerticalStrut(4));
        box.setBorder(new TitledBorder("Parameters"));
        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), box, "Which target variable?", 3);
        String setNode = (String)comboBox.getSelectedItem();
        Preferences.userRoot().put("mbSavedNode", setNode);
        return setNode;
    }
}

