/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.FactorAnalysis;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.util.TextTable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class FactorAnalysisRunner
extends AbstractAlgorithmRunner {
    static final long serialVersionUID = 23L;
    private DataWrapper dataWrapper;
    private String output;
    private DataSet dataSet;
    private DoubleMatrix2D rotatedSolution;
    private double threshold;

    public DataWrapper getDataWrapper() {
        return this.dataWrapper;
    }

    public FactorAnalysisRunner(DataWrapper dataWrapper, PcSearchParams pc) {
        super(dataWrapper, (SearchParams)pc, null);
        this.dataWrapper = dataWrapper;
    }

    public static FactorAnalysisRunner serializableInstance() {
        return new FactorAnalysisRunner(DataWrapper.serializableInstance(), PcSearchParams.serializableInstance());
    }

    @Override
    public void execute() {
        int i;
        FactorAnalysis analysis = new FactorAnalysis((DataSet)this.dataWrapper.getDataModelList().get(0));
        this.threshold = 0.2;
        DenseDoubleMatrix2D unrotatedSolution = analysis.successiveResidual();
        this.rotatedSolution = FactorAnalysis.successiveFactorVarimax(unrotatedSolution);
        this.dataSet = (DataSet)this.dataWrapper.getDataModelList().get(0);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        this.output = "Unrotated Factor Loading Matrix:\n";
        this.output = this.output + this.tableString(unrotatedSolution, nf, Double.POSITIVE_INFINITY);
        if (unrotatedSolution.columns() != 1) {
            this.output = this.output + "\n\nRotated Matrix (using sequential varimax):\n";
            this.output = this.output + this.tableString(this.rotatedSolution, nf, this.threshold);
        }
        SemGraph graph = new SemGraph();
        Vector<Node> observedVariables = new Vector<Node>();
        for (Node a : this.getDataSet().getVariables()) {
            graph.addNode(a);
            observedVariables.add(a);
        }
        Vector<ContinuousVariable> factors = new Vector<ContinuousVariable>();
        for (i = 0; i < this.getRotatedSolution().columns(); ++i) {
            ContinuousVariable factor = new ContinuousVariable("Factor" + (i + 1));
            factor.setNodeType(NodeType.LATENT);
            graph.addNode(factor);
            factors.add(factor);
        }
        for (i = 0; i < this.getRotatedSolution().rows(); ++i) {
            for (int j = 0; j < this.getRotatedSolution().columns(); ++j) {
                if (!(Math.abs(this.getRotatedSolution().get(i, j)) > this.getThreshold())) continue;
                graph.addDirectedEdge((Node)factors.get(j), (Node)observedVariables.get(i));
            }
        }
        this.setResultGraph(graph);
    }

    private String tableString(DoubleMatrix2D matrix, NumberFormat nf, double threshold) {
        TextTable table = new TextTable(matrix.rows() + 1, matrix.columns() + 1);
        for (int i = 0; i < matrix.rows() + 1; ++i) {
            for (int j = 0; j < matrix.columns() + 1; ++j) {
                if (i > 0 && j == 0) {
                    table.setToken(i, j, "X" + i);
                    continue;
                }
                if (i == 0 && j > 0) {
                    table.setToken(i, j, "Factor " + j);
                    continue;
                }
                if (i <= 0 || j <= 0) continue;
                double coefficient = matrix.get(i - 1, j - 1);
                String token = !Double.isNaN(coefficient) ? nf.format(coefficient) : "Undefined";
                token = token + (Math.abs(coefficient) > threshold ? "*" : " ");
                table.setToken(i, j, token);
            }
        }
        return table.toString();
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    public String getOutput() {
        return this.output;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public DoubleMatrix2D getRotatedSolution() {
        return this.rotatedSolution;
    }

    public double getThreshold() {
        return this.threshold;
    }
}

