/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fci;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BasicSearchParams;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.FciIndTestParams;
import edu.cmu.tetradapp.model.FciSearchParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.ArrayList;
import java.util.List;

public class FciRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public FciRunner(DataWrapper dataWrapper, FciSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public FciRunner(GraphSource graphWrapper, FciSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public FciRunner(DataWrapper dataWrapper, FciSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public FciRunner(Graph graph, FciSearchParams params) {
        super(graph, params);
    }

    public FciRunner(Graph graph, FciSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graph, (SearchParams)params, knowledgeBoxModel);
    }

    public FciRunner(GraphWrapper graphWrapper, FciSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public FciRunner(DagWrapper dagWrapper, FciSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public FciRunner(SemGraphWrapper dagWrapper, FciSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public static FciRunner serializableInstance() {
        return new FciRunner((Graph)Dag.serializableInstance(), FciSearchParams.serializableInstance());
    }

    @Override
    public void execute() {
        Knowledge knowledge = this.getParams().getKnowledge();
        SearchParams searchParams = this.getParams();
        FciIndTestParams indTestParams = (FciIndTestParams)searchParams.getIndTestParams();
        Fci fci = new Fci(this.getIndependenceTest());
        fci.setKnowledge(knowledge);
        fci.setCompleteRuleSetUsed(indTestParams.isCompleteRuleSetUsed());
        fci.setPossibleDsepSearchDone(indTestParams.isPossibleDsepDone());
        fci.setMaxReachablePathLength(indTestParams.getMaxReachablePathLength());
        fci.setDepth(indTestParams.getDepth());
        Graph graph = fci.search();
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        IndTestType testType;
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        SearchParams params = this.getParams();
        if (this.getParams() instanceof BasicSearchParams) {
            BasicSearchParams _params = (BasicSearchParams)params;
            testType = _params.getIndTestType();
        } else {
            FciSearchParams _params = (FciSearchParams)params;
            testType = _params.getIndTestType();
        }
        return new IndTestFactory().getTest(dataModel, params, testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }
}

