/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetradapp.model.BasicIndTestParams;
import edu.cmu.tetradapp.model.IndTestParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public final class GaParams
implements SearchParams {
    static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();
    private IndTestParams indTestParams = new BasicIndTestParams();
    private double alpha = 0.05;
    private double bias = 1.0;
    private double timeLimit = 0.0;
    private IndTestType indTestType;
    private List varNames;
    private Graph sourceGraph;

    public static GaParams serializableInstance() {
        return new GaParams();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double newValue) {
        if (newValue < 0.0 || newValue > 1.0) {
            throw new IllegalArgumentException("Alpha value out of range: " + newValue);
        }
        this.alpha = newValue;
    }

    public void setBias(double newValue) {
        if (newValue <= 0.0) {
            throw new IllegalArgumentException("bias value out of range: " + newValue);
        }
        this.bias = newValue;
    }

    public void setTimeLimit(double newValue) {
        if (newValue < 0.0) {
            throw new IllegalArgumentException("bias value out of range: " + newValue);
        }
        System.out.println("Time limit set to " + newValue);
        this.timeLimit = newValue;
    }

    public double getTimeLimit() {
        return this.timeLimit;
    }

    public double getBias() {
        return this.bias;
    }

    @Override
    public IndTestParams getIndTestParams() {
        return this.indTestParams;
    }

    @Override
    public void setIndTestParams2(IndTestParams indTestParams) {
        if (indTestParams == null) {
            throw new NullPointerException();
        }
        this.indTestParams = indTestParams;
    }

    public List getVarNames() {
        return this.varNames;
    }

    public void setVarNames(List varNames) {
        this.varNames = varNames;
    }

    @Override
    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public void setSourceGraph(Graph graph) {
        this.sourceGraph = graph;
    }

    @Override
    public void setIndTestType(IndTestType indTestType) {
        this.indTestType = indTestType;
    }

    @Override
    public IndTestType getIndTestType() {
        return this.indTestType;
    }

    @Override
    public Knowledge getKnowledge() {
        return new Knowledge(this.knowledge);
    }

    @Override
    public void setKnowledge(Knowledge k) {
        if (this.knowledge == null) {
            throw new NullPointerException("Cannot set a null knowledge.");
        }
        this.knowledge = new Knowledge(this.knowledge);
    }

    public void verboseDescription() {
        System.out.println("Verbose GaParam description " + this.toString());
        System.out.println(this.knowledge.toString());
        System.out.println(this.alpha);
        System.out.println(this.bias);
        System.out.println(this.timeLimit);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
        if (this.indTestParams == null) {
            throw new NullPointerException();
        }
        if (!(this.alpha >= 0.0) || !(this.alpha <= 1.0)) {
            throw new IllegalStateException("Alpha out of range: " + this.alpha);
        }
        if (!(this.bias > 0.0)) {
            throw new IllegalStateException("Bias out of range: " + this.bias);
        }
        if (!(this.timeLimit >= 0.0)) {
            throw new IllegalStateException("Time limit out of range: " + this.bias);
        }
    }
}

