/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GeneralizedSemPmWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class GeneralizedSemImWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private final GeneralizedSemIm semIm;
    private boolean showErrors;

    private GeneralizedSemImWrapper(GeneralizedSemPm semPm) {
        if (semPm == null) {
            throw new NullPointerException("SEM PM must not be null.");
        }
        this.semIm = new GeneralizedSemIm(semPm);
        this.log(this.semIm);
    }

    public GeneralizedSemImWrapper(GeneralizedSemPmWrapper wrapper) {
        this(wrapper.getSemPm());
    }

    public GeneralizedSemImWrapper(GeneralizedSemPmWrapper genSemPm, SemImWrapper imWrapper) {
        this.semIm = new GeneralizedSemIm(genSemPm.getSemPm(), imWrapper.getSemIm());
    }

    public static GeneralizedSemImWrapper serializableInstance() {
        return new GeneralizedSemImWrapper(GeneralizedSemPmWrapper.serializableInstance());
    }

    public GeneralizedSemIm getSemIm() {
        return this.semIm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semIm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.semIm.getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    private void log(GeneralizedSemIm im) {
        TetradLogger.getInstance().log("info", "Generalized SEM IM");
        TetradLogger.getInstance().log("im", im.toString());
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

