/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.LinkedList;
import java.util.List;

public class LocalOrientationTestRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public LocalOrientationTestRunner(DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public LocalOrientationTestRunner(Graph graph, PcSearchParams params) {
        super(graph, params);
    }

    public LocalOrientationTestRunner(GraphWrapper graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public LocalOrientationTestRunner(DagWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public LocalOrientationTestRunner(SemGraphWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public static LocalOrientationTestRunner serializableInstance() {
        return new LocalOrientationTestRunner((Graph)Dag.serializableInstance(), PcSearchParams.serializableInstance());
    }

    @Override
    public void execute() {
        EdgeListGraph graph1 = new EdgeListGraph(this.getSourceGraph());
        SearchGraphUtils.basicPattern(graph1);
        IndependenceTest test = this.getIndependenceTest();
        List<Node> variables = test.getVariables();
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Node variable : variables) {
            nodes.add(variable);
        }
        EdgeListGraph graph2 = new EdgeListGraph(nodes);
        List<Edge> edges = graph1.getEdges();
        for (Edge edge : edges) {
            Node var1 = test.getVariable(edge.getNode1().getName());
            Node var2 = test.getVariable(edge.getNode2().getName());
            if (var1 == null || var2 == null) continue;
            graph2.addUndirectedEdge(var1, var2);
        }
        SearchGraphUtils.orientCollidersLocally(new Knowledge(), graph2, this.getIndependenceTest(), -1);
        new MeekRules().orientImplied(graph2);
        this.setResultGraph(graph2);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = this.getParams().getIndTestType();
        return new IndTestFactory().getTest(dataModel, this.getParams(), testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }
}

