/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.model.MimIndTestParams;
import edu.cmu.tetradapp.model.MimParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class MimBuildIndTestParams
implements MimIndTestParams {
    static final long serialVersionUID = 23L;
    private int numClusters;
    private double alpha = 0.05;
    private int algorithmType;
    private MimParams originalParams;
    private List varNames;

    public MimBuildIndTestParams(double alpha, int numClusters, int type, MimParams originalParams) {
        this.setAlpha(alpha);
        this.setNumClusters(numClusters);
        this.setAlgorithmType(type);
        this.originalParams = originalParams;
    }

    public static MimBuildIndTestParams serializableInstance() {
        return new MimBuildIndTestParams(0.05, 1, 1, null);
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(int numClusters) {
        if (numClusters < 1) {
            throw new IllegalArgumentException("Number of clusters should be >= 1!");
        }
        this.numClusters = numClusters;
    }

    public int getAlgorithmType() {
        return this.algorithmType;
    }

    public void setAlgorithmType(int type) {
        this.algorithmType = type;
    }

    public Knowledge getKnowledge() {
        return this.originalParams.getKnowledge();
    }

    public Clusters getClusters() {
        return this.originalParams.getClusters();
    }

    public Graph getSourceGraph() {
        return this.originalParams.getSourceGraph();
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha out of range: " + alpha);
        }
        this.alpha = alpha;
    }

    @Override
    public List getVarNames() {
        return this.varNames;
    }

    public void setVarNames(List varNames) {
        this.varNames = varNames;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.numClusters < 1) {
            throw new IllegalStateException("NumClusters out of range: " + this.numClusters);
        }
        if (this.alpha < 0.0 || this.alpha > 1.0) {
            throw new IllegalStateException("Alpha out of range: " + this.alpha);
        }
    }

    public void setKnowledge(Knowledge knowledge) {
        this.originalParams.setKnowledge(knowledge);
    }
}

