/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndTestMimBuild;
import edu.cmu.tetrad.search.MimBuild;
import edu.cmu.tetrad.search.MimUtils;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetradapp.model.AbstractMimRunner;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MimBuildParams;
import edu.cmu.tetradapp.model.PurifyRunner;
import java.util.prefs.Preferences;

public class MimBuildRunner
extends AbstractMimRunner
implements GraphSource {
    static final long serialVersionUID = 23L;

    public MimBuildRunner(DataWrapper dataWrapper, MimBuildParams params) {
        super(dataWrapper, params.getClusters(), params);
        this.setClusters(params.getClusters());
    }

    public MimBuildRunner(BuildPureClustersRunner pureClustersRunner, MimBuildParams params) {
        super(pureClustersRunner, params);
        this.setClusters(params.getClusters());
    }

    public MimBuildRunner(PurifyRunner runner, MimBuildParams params) {
        super(runner, params);
        this.setClusters(params.getClusters());
    }

    public MimBuildRunner(MimBuildRunner runner, MimBuildParams params) {
        super(runner, params);
        this.setClusters(params.getClusters());
    }

    public static MimBuildRunner serializableInstance() {
        DataSet dataSet = DataUtils.discreteSerializableInstance();
        DataWrapper dataWrapper = new DataWrapper(dataSet);
        return new MimBuildRunner(dataWrapper, MimBuildParams.serializableInstance());
    }

    @Override
    public void execute() throws Exception {
        IndTestMimBuild test = this.getIndependenceTest();
        test.setAlgorithmType(this.getParams().getAlgorithmType());
        test.setSignificance(this.getParams().getAlpha());
        try {
            MimBuild mimBuildSearch = new MimBuild(test, this.getParams().getKnowledge());
            if (this.getClusters().getNumClusters() == 0) {
                this.setResultGraph(new EdgeListGraph());
                return;
            }
            Graph searchGraph = mimBuildSearch.search();
            this.setResultGraph(searchGraph);
            Clusters clusters = MimUtils.convertToClusters(searchGraph);
            this.setClusters(clusters);
            this.setStructureGraph(MimUtils.extractStructureGraph(searchGraph));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Mimbuild exception", e);
        }
    }

    private IndTestMimBuild getIndependenceTest() {
        if (this.getData() instanceof DataSet) {
            DataSet dataContinuous = (DataSet)this.getData();
            double alpha = Preferences.userRoot().getDouble("alpha", 0.05);
            return new IndTestMimBuild(dataContinuous, alpha, this.getParams().getClusters());
        }
        if (this.getData() instanceof CovarianceMatrix) {
            CovarianceMatrix data = (CovarianceMatrix)this.getData();
            double alpha = Preferences.userRoot().getDouble("alpha", 0.05);
            return new IndTestMimBuild(data, alpha, this.getParams().getClusters());
        }
        throw new IllegalStateException("Data source must be a continuous data set: " + this.getData().getClass());
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    public SemPm getSemPm() {
        Graph graph = super.getResultGraph();
        return new SemPm(graph);
    }
}

