/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MissingDataInjectorParams;
import java.io.IOException;
import java.io.ObjectInputStream;

public class MissingDataInjectorWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private DataSet outputDataSet;

    public MissingDataInjectorWrapper(DataWrapper wrapper, MissingDataInjectorParams params) {
        DataSet dataSet = (DataSet)wrapper.getSelectedDataModel();
        int numVars = dataSet.getNumColumns();
        double prob = params.getProb();
        double[] probs = new double[numVars];
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = prob;
        }
        this.outputDataSet = DataUtils.addMissingData(dataSet, probs);
        this.setDataModel(this.outputDataSet);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data with missing values injected randomly.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new MissingDataInjectorWrapper(DataWrapper.serializableInstance(), MissingDataInjectorParams.serializableInstance());
    }

    public DataSet getOutputDataset() {
        return this.outputDataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.outputDataSet == null) {
            throw new NullPointerException();
        }
    }
}

