/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Pcd;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.PcIndTestParams;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class PcdRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public PcdRunner(DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public PcdRunner(DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public PcdRunner(Graph graph, PcSearchParams params) {
        super(graph, params);
    }

    public PcdRunner(Graph graph, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graph, (SearchParams)params, knowledgeBoxModel);
    }

    public PcdRunner(GraphWrapper graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public PcdRunner(GraphWrapper graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public PcdRunner(GraphSource graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public PcdRunner(GraphSource graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public PcdRunner(DagWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public PcdRunner(DagWrapper dagWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dagWrapper.getDag(), (SearchParams)params, knowledgeBoxModel);
    }

    public PcdRunner(SemGraphWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public PcdRunner(SemGraphWrapper dagWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dagWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    public static PcdRunner serializableInstance() {
        return new PcdRunner((Graph)Dag.serializableInstance(), PcSearchParams.serializableInstance());
    }

    @Override
    public void execute() {
        Graph graph;
        Knowledge knowledge = this.getParams().getKnowledge();
        PcSearchParams searchParams = (PcSearchParams)this.getParams();
        PcIndTestParams indTestParams = (PcIndTestParams)searchParams.getIndTestParams();
        Pcd pc = new Pcd(this.getIndependenceTest());
        pc.setKnowledge(knowledge);
        pc.setDepth(indTestParams.getDepth());
        try {
            graph = pc.search();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There was an error, probably because the independence test doesn't support determinististic checks.");
            return;
        }
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = this.getParams().getIndTestType();
        IndependenceTest test = new IndTestFactory().getTest(dataModel, this.getParams(), testType);
        System.out.println(test);
        return test;
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        return triplesList;
    }
}

