/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.predict.ManipulatedVariable;
import edu.cmu.tetrad.predict.Prediction;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.FciRunnerOld;
import edu.cmu.tetradapp.model.SemDataWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;

public class PredictionRunner
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private Graph pag;
    private DataSet dataSet;
    private ManipulatedVariable manipulatedVariable;
    private Set conditioningVariables;
    private Node predictedVariable;
    private double result = Double.NaN;

    public PredictionRunner(Graph pag, DataSet dataSet) {
        if (pag == null) {
            throw new NullPointerException("Please specify a PAG.");
        }
        if (dataSet == null) {
            throw new NullPointerException("Please specify a data set.");
        }
        this.pag = pag;
        this.dataSet = dataSet;
    }

    public PredictionRunner(FciRunnerOld f, DataWrapper w) {
        this(new EdgeListGraph(f.getResultGraph()), (DataSet)w.getSelectedDataModel());
    }

    public PredictionRunner(FciRunnerOld f, SemDataWrapper w) {
        this(new EdgeListGraph(f.getResultGraph()), (DataSet)w.getSelectedDataModel());
    }

    public static PredictionRunner serializableInstance() {
        return new PredictionRunner(EdgeListGraph.serializableInstance(), DataUtils.continuousSerializableInstance());
    }

    public void execute() {
        if (this.predictedVariable == null || this.manipulatedVariable == null) {
            throw new NullPointerException("You must have both a predicted and a manipulated variable set.");
        }
        Prediction prediction = new Prediction(this.pag, this.dataSet, this.manipulatedVariable, this.predictedVariable, this.conditioningVariables);
        this.setResult(prediction.predict());
    }

    public double getResult() {
        return this.result;
    }

    public Graph getPag() {
        return this.pag;
    }

    public void setManipulatedVariable(ManipulatedVariable manipulatedVariable) {
        this.manipulatedVariable = manipulatedVariable;
    }

    public void setPredictedVariable(Node predictedVariable) {
        this.predictedVariable = predictedVariable;
    }

    public void setConditioningVariables(Set conditioningVariables) {
        this.conditioningVariables = conditioningVariables;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void setResult(double result) {
        this.result = result;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.pag == null) {
            throw new NullPointerException();
        }
        if (this.dataSet == null) {
            throw new NullPointerException();
        }
    }
}

