/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.MimUtils;
import edu.cmu.tetrad.search.Purify;
import edu.cmu.tetradapp.model.AbstractMimRunner;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.PurifyParams;

public class PurifyRunner
extends AbstractMimRunner
implements GraphSource {
    static final long serialVersionUID = 23L;

    public PurifyRunner(DataWrapper dataWrapper, PurifyParams params) {
        super(dataWrapper, params.getClusters(), params);
    }

    public PurifyRunner(BuildPureClustersRunner bpc, PurifyParams params) {
        super(bpc, params);
    }

    public static PurifyRunner serializableInstance() {
        return new PurifyRunner(DataWrapper.serializableInstance(), PurifyParams.serializableInstance());
    }

    @Override
    public void execute() {
        Purify purify;
        DataModel source = this.getData();
        if (source instanceof CovarianceMatrix) {
            CovarianceMatrix covMatrix = (CovarianceMatrix)source;
            CorrelationMatrix corrMatrix = new CorrelationMatrix(covMatrix);
            purify = new Purify(corrMatrix, this.getParams().getAlpha(), this.getParams().getTetradTestType(), this.getParams().getClusters());
        } else if (source instanceof DataSet) {
            purify = new Purify((DataSet)source, this.getParams().getAlpha(), this.getParams().getTetradTestType(), this.getParams().getClusters());
        } else {
            throw new RuntimeException("Data source for Purify of invalid type!");
        }
        Graph searchGraph = purify.search();
        this.setResultGraph(searchGraph);
        GraphUtils.arrangeClustersInLine(this.getResultGraph(), true);
        this.setClusters(MimUtils.convertToClusters(searchGraph));
    }

    @Override
    public Clusters getClusters() {
        return super.getClusters();
    }

    @Override
    public void setClusters(Clusters clusters) {
        super.setClusters(clusters);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }
}

