/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.Indexable;
import edu.cmu.tetradapp.model.CpcRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GesRunner;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.ImagesRunner;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScoredGraphsWrapper
implements SessionModel,
GraphSource,
Indexable {
    static final long serialVersionUID = 23L;
    private String name;
    private Graph selectedGraph;
    private Map<Graph, Double> graphsToScores;
    private int index;

    public ScoredGraphsWrapper(Map<Graph, Double> graphsToScores) {
        TetradLogger.getInstance().log("info", "Show DAGs in Pattern");
        if (graphsToScores == null) {
            throw new NullPointerException("The list of graphs must not be null.");
        }
        this.graphsToScores = graphsToScores;
        if (!graphsToScores.keySet().isEmpty()) {
            this.index = 0;
        }
        this.log();
    }

    public ScoredGraphsWrapper(ScoredGraphsWrapper graphWrapper) {
        TetradLogger.getInstance().log("info", "Show DAGs in Pattern");
        this.graphsToScores = new LinkedHashMap<Graph, Double>();
        for (Graph graph : graphWrapper.graphsToScores.keySet()) {
            this.graphsToScores.put(new EdgeListGraph(graph), graphWrapper.graphsToScores.get(graph));
        }
        this.log();
    }

    public ScoredGraphsWrapper(Graph graph) {
        List<Graph> dags = MbUtils.generatePatternDags(graph, false);
        this.graphsToScores = new HashMap<Graph, Double>();
        for (Graph _graph : dags) {
            double score = Double.NaN;
            this.graphsToScores.put(_graph, score);
        }
        if (!this.graphsToScores.keySet().isEmpty()) {
            this.index = 0;
        }
        this.log();
    }

    public ScoredGraphsWrapper(ImagesRunner runner) {
        this(runner.getDagsToScores());
    }

    public ScoredGraphsWrapper(GesRunner runner) {
        this(runner.getDagsToScores());
    }

    public ScoredGraphsWrapper(DagWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public ScoredGraphsWrapper(GraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public ScoredGraphsWrapper(SemGraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public ScoredGraphsWrapper(PcRunner wrapper) {
        this(wrapper.getGraph());
    }

    public ScoredGraphsWrapper(CpcRunner wrapper) {
        this(wrapper.getGraph());
    }

    public static ScoredGraphsWrapper serializableInstance() {
        return new ScoredGraphsWrapper(new LinkedHashMap<Graph, Double>());
    }

    public Map<Graph, Double> getGraphsToScores() {
        LinkedHashMap<Graph, Double> _graphsToScores = new LinkedHashMap<Graph, Double>();
        for (Graph graph : this.graphsToScores.keySet()) {
            _graphsToScores.put(new EdgeListGraph(graph), this.graphsToScores.get(graph));
        }
        return _graphsToScores;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getGraph() {
        Iterator<Graph> graphIterator = this.graphsToScores.keySet().iterator();
        if (!graphIterator.hasNext()) {
            return null;
        }
        for (int i = 0; i < this.getIndex() - 1; ++i) {
            graphIterator.next();
        }
        return graphIterator.next();
    }

    public Graph getSelectedGraph() {
        return this.getGraph();
    }

    private void log() {
        TetradLogger.getInstance().log("info", "DAGs in Pattern");
        TetradLogger.getInstance().log("selected_graph", "\nSelected Graph\n");
        TetradLogger.getInstance().log("selected_graph", this.getGraph() + "");
        TetradLogger.getInstance().log("all_graphs", "\nAll Graphs:\n");
        int index = 0;
        for (Graph graph : this.graphsToScores.keySet()) {
            TetradLogger.getInstance().log("all_graphs", "\nGraph #" + ++index);
            TetradLogger.getInstance().log("all_graphs", graph + "");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
        TetradLogger.getInstance().log("selected_graph", "\nSelected Graph\n");
        TetradLogger.getInstance().log("selected_graph", this.getGraph() + "");
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

