/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JOptionPane;

public class SemEstimatorWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private SemEstimator semEstimator;

    private SemEstimatorWrapper(DataSet dataSet, SemPm semPm) {
        this.semEstimator = new SemEstimator(dataSet, semPm);
    }

    public SemEstimatorWrapper(DataWrapper dataWrapper, SemPmWrapper semPmWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("Data wrapper must not be null.");
        }
        if (semPmWrapper == null) {
            throw new NullPointerException("OldSem PM Wrapper must not be null.");
        }
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
            SemPm semPm = semPmWrapper.getSemPm();
            this.semEstimator = new SemEstimator(dataSet, semPm);
            if (!this.degreesOfFreedomCheck(semPm)) {
                return;
            }
            this.semEstimator.estimate();
        } else if (dataModel instanceof CovarianceMatrix) {
            CovarianceMatrix covMatrix = (CovarianceMatrix)dataModel;
            SemPm semPm = semPmWrapper.getSemPm();
            this.semEstimator = new SemEstimator(covMatrix, semPm);
            if (!this.degreesOfFreedomCheck(semPm)) {
                return;
            }
            this.semEstimator.estimate();
        } else {
            throw new IllegalArgumentException("Data wrapper must be either a DataSet or a CovarianceMatrix.");
        }
        this.log();
    }

    public SemEstimatorWrapper(DataWrapper dataWrapper, SemImWrapper semImWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (semImWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        SemPm semPm = semImWrapper.getSemIm().getSemPm();
        this.semEstimator = new SemEstimator(dataSet, semPm);
        if (!this.degreesOfFreedomCheck(semPm)) {
            return;
        }
        this.semEstimator.estimate();
        this.log();
    }

    private boolean degreesOfFreedomCheck(SemPm semPm) {
        int ret;
        return semPm.getDof() >= 1 || (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This model has nonpositive degrees of freedom (DOF = " + semPm.getDof() + "). " + "\nEstimation will be uninformative. Are you sure you want to proceed?", "Please confirm", 0, 2)) == 0;
    }

    public SemEstimatorWrapper(DataWrapper dataWrapper, SemPmWrapper semPmWrapper, SemImWrapper semImWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (semPmWrapper == null) {
            throw new NullPointerException();
        }
        if (semImWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        SemPm semPm = semPmWrapper.getSemPm();
        SemIm semIm = semImWrapper.getSemIm();
        this.semEstimator = new SemEstimator(dataSet, semPm);
        if (!this.degreesOfFreedomCheck(semPm)) {
            return;
        }
        this.semEstimator.setTrueSemIm(semIm);
        this.semEstimator.estimate();
        this.log();
    }

    public static SemEstimatorWrapper serializableInstance() {
        DataSet dataSet = DataUtils.continuousSerializableInstance();
        return new SemEstimatorWrapper(dataSet, SemPm.serializableInstance());
    }

    public SemEstimator getSemEstimator() {
        return this.semEstimator;
    }

    public void setSemEstimator(SemEstimator semEstimator) {
        this.semEstimator = semEstimator;
    }

    public SemIm getEstimatedSemIm() {
        return this.semEstimator.getEstimatedSem();
    }

    public SemOptimizer getSemOptimizer() {
        return this.semEstimator.getSemOptimizer();
    }

    @Override
    public Graph getGraph() {
        return this.semEstimator.getEstimatedSem().getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log() {
        TetradLogger.getInstance().log("info", "EM-Estimated Bayes IM:");
        TetradLogger.getInstance().log("im", "" + this.getEstimatedSemIm());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semEstimator == null) {
            throw new NullPointerException();
        }
    }
}

