/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.RegressionRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.prefs.Preferences;

public class SemGraphWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private SemGraph semGraph;

    public SemGraphWrapper(SemGraph graph) {
        if (graph == null) {
            throw new NullPointerException("MAG must not be null.");
        }
        this.semGraph = graph;
        this.semGraph.setShowErrorTerms(false);
        this.log();
    }

    public SemGraphWrapper(GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.semGraph = new SemGraph();
            this.semGraph.setShowErrorTerms(false);
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public SemGraphWrapper(SemGraphWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.semGraph = new SemGraph(graphWrapper.getSemGraph());
            this.semGraph.setShowErrorTerms(false);
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public SemGraphWrapper(DagWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.semGraph = new SemGraph(graphWrapper.getDag());
            this.semGraph.setShowErrorTerms(false);
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public SemGraphWrapper(GraphWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.semGraph = new SemGraph(graphWrapper.getGraph());
            this.semGraph.setShowErrorTerms(false);
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.createRandomDag();
        }
        this.log();
    }

    public SemGraphWrapper(AbstractAlgorithmRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public SemGraphWrapper(DataWrapper wrapper) {
        this(new SemGraph(new EdgeListGraph(wrapper.getVariables())));
        GraphUtils.arrangeInCircle(this.semGraph, 200, 200, 150);
    }

    public SemGraphWrapper(BayesPmWrapper wrapper) {
        this(new SemGraph(wrapper.getBayesPm().getDag()));
    }

    public SemGraphWrapper(BayesImWrapper wrapper) {
        this(new SemGraph(wrapper.getBayesIm().getBayesPm().getDag()));
    }

    public SemGraphWrapper(BayesEstimatorWrapper wrapper) {
        this(new SemGraph(wrapper.getEstimatedBayesIm().getBayesPm().getDag()));
    }

    public SemGraphWrapper(CptInvariantUpdaterWrapper wrapper) {
        this(new SemGraph(wrapper.getBayesUpdater().getManipulatedGraph()));
    }

    public SemGraphWrapper(SemPmWrapper wrapper) {
        this(new SemGraph(wrapper.getSemPm().getGraph()));
    }

    public SemGraphWrapper(SemImWrapper wrapper) {
        this(new SemGraph(wrapper.getSemIm().getSemPm().getGraph()));
    }

    public SemGraphWrapper(SemEstimatorWrapper wrapper) {
        this(new SemGraph(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph()));
    }

    public SemGraphWrapper(RegressionRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public SemGraphWrapper(BuildPureClustersRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public SemGraphWrapper(MimBuildRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public static SemGraphWrapper serializableInstance() {
        return new SemGraphWrapper(SemGraph.serializableInstance());
    }

    public SemGraph getSemGraph() {
        return this.semGraph;
    }

    public void setSemGraph(SemGraph graph) {
        this.semGraph = graph;
        this.semGraph.setShowErrorTerms(false);
        this.log();
    }

    private void log() {
        TetradLogger.getInstance().log("info", "Structural Equation Model (SEM) Graph");
        TetradLogger.getInstance().log("graph", "" + this.semGraph);
    }

    private void createRandomDag() {
        Graph graph = null;
        while (graph == null) {
            Dag dag;
            boolean uniformlySelected = Preferences.userRoot().getBoolean("graphUniformlySelected", true);
            int numMeasuredNodes = Preferences.userRoot().getInt("newGraphNumMeasuredNodes", 5);
            int numLatents = Preferences.userRoot().getInt("newGraphNumLatents", 0);
            int newGraphNumEdges = Preferences.userRoot().getInt("newGraphNumEdges", 3);
            boolean connected = Preferences.userRoot().getBoolean("randomGraphConnected", false);
            if (uniformlySelected) {
                int maxDegree = Preferences.userRoot().getInt("randomGraphMaxDegree", 6);
                int maxIndegree = Preferences.userRoot().getInt("randomGraphMaxIndegree", 3);
                int maxOutdegree = Preferences.userRoot().getInt("randomGraphMaxOutdegree", 3);
                dag = GraphUtils.randomDag(numMeasuredNodes + numLatents, numLatents, newGraphNumEdges, maxDegree, maxIndegree, maxOutdegree, connected);
            } else {
                while ((dag = GraphUtils.randomDag(numMeasuredNodes + numLatents, numLatents, newGraphNumEdges, 30, 15, 15, connected)).getNumEdges() < newGraphNumEdges) {
                }
            }
            boolean addCycles = Preferences.userRoot().getBoolean("randomGraphAddCycles", false);
            if (addCycles) {
                int minNumCycles = Preferences.userRoot().getInt("randomGraphMinNumCycles", 0);
                int minCycleLength = Preferences.userRoot().getInt("randomGraphMinCycleLength", 2);
                graph = GraphUtils.addCycles2(dag, minNumCycles, minCycleLength);
                continue;
            }
            graph = new EdgeListGraph(dag);
        }
        this.semGraph = new SemGraph(graph);
        this.semGraph.setShowErrorTerms(false);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semGraph == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.semGraph;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

