/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StandardizeWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public StandardizeWrapper(DataWrapper data) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataSet dataSet = (DataSet)data.getDataModelList().get(0);
        DoubleMatrix2D matrix2D = DataUtils.standardizeData(dataSet.getDoubleData());
        ColtDataSet _dataSet = ColtDataSet.makeContinuousData(dataSet.getVariables(), matrix2D);
        this.setDataModel(_dataSet);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Standardization fo the parent data.", this.getDataModelList());
    }

    public static StandardizeWrapper serializableInstance() {
        return new StandardizeWrapper(DataWrapper.serializableInstance());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

