/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.FactoredBayesStructuralEM;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesDataWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.StructEmBayesSearchParams;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StructEmBayesSearchRunner
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesPm bayesPm;
    private DataSet dataSet;
    private BayesIm estimatedBayesIm;

    public StructEmBayesSearchRunner(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("BayesDataWrapper must not be null.");
        }
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null");
        }
        this.dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        this.bayesPm = bayesPmWrapper.getBayesPm();
        this.estimate(this.dataSet, this.bayesPm);
        this.log();
    }

    public StructEmBayesSearchRunner(BayesDataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper) {
        this((DataWrapper)dataWrapper, bayesPmWrapper);
    }

    public StructEmBayesSearchRunner(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper, StructEmBayesSearchParams params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (bayesPmWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        FactoredBayesStructuralEM estimator = new FactoredBayesStructuralEM(dataSet, bayesPmWrapper.getBayesPm());
        this.dataSet = estimator.getDataSet();
        try {
            this.estimatedBayesIm = estimator.maximization(params.getTolerance());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        this.log();
    }

    public StructEmBayesSearchRunner(DataWrapper dataWrapper, BayesImWrapper bayesImWrapper, StructEmBayesSearchParams params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (bayesImWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        this.bayesPm = bayesImWrapper.getBayesIm().getBayesPm();
        FactoredBayesStructuralEM estimator = new FactoredBayesStructuralEM(dataSet, this.bayesPm);
        this.dataSet = estimator.getDataSet();
        try {
            this.estimatedBayesIm = estimator.maximization(params.getTolerance());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please specify the search tolerance first.");
        }
        this.log();
    }

    public static StructEmBayesSearchRunner serializableInstance() {
        return new StructEmBayesSearchRunner(DataWrapper.serializableInstance(), BayesPmWrapper.serializableInstance());
    }

    public BayesIm getEstimatedBayesIm() {
        return this.estimatedBayesIm;
    }

    private void estimate(DataSet DataSet2, BayesPm bayesPm) {
        double thresh = 1.0E-4;
        try {
            FactoredBayesStructuralEM estimator = new FactoredBayesStructuralEM(DataSet2, bayesPm);
            this.dataSet = estimator.getDataSet();
            this.estimatedBayesIm = estimator.maximization(thresh);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.estimatedBayesIm == null) {
            throw new NullPointerException();
        }
        if (this.dataSet == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.estimatedBayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log() {
        TetradLogger.getInstance().log("info", "EM-Estimated Bayes IM");
        TetradLogger.getInstance().log("im", "" + this.estimatedBayesIm);
    }
}

