/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.model.calculator.Transformation;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestTransform
extends TestCase {
    public TestTransform(String name) {
        super(name);
    }

    public void testTransformWithNewColumnVariable() {
        List<Node> list = Arrays.asList(new ContinuousVariable("x"), new ContinuousVariable("y"));
        ColtDataSet data = new ColtDataSet(1, list);
        data.setDouble(0, 0, 1.0);
        data.setDouble(1, 0, 1.0);
        data.setDouble(0, 1, 1.0);
        data.setDouble(1, 1, 1.0);
        System.out.println("Starting with: \n " + data);
        try {
            String eq = "w = (x + y) * x";
            Transformation.transform(data, eq);
            System.out.println("Transformed using " + eq + " and got: \n" + data);
            TestTransform.assertTrue(data.getDouble(0, 2) == 2.0);
            TestTransform.assertTrue(data.getDouble(0, 2) == 2.0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestTransform.fail(ex.getMessage());
        }
    }

    public void testSingleTransforms() {
        List<Node> list = Arrays.asList(new ContinuousVariable("x"), new ContinuousVariable("y"), new ContinuousVariable("z"));
        ColtDataSet data = new ColtDataSet(2, list);
        data.setDouble(0, 0, 2.0);
        data.setDouble(1, 0, 3.0);
        data.setDouble(2, 0, 4.0);
        data.setDouble(0, 1, 1.0);
        data.setDouble(1, 1, 6.0);
        data.setDouble(2, 1, 5.0);
        data.setDouble(0, 2, 8.0);
        data.setDouble(1, 2, 8.0);
        data.setDouble(2, 2, 8.0);
        System.out.println("Staring with: \n" + data);
        ColtDataSet copy = new ColtDataSet(data);
        try {
            String eq = "z = (x + y)";
            Transformation.transform(copy, eq);
            System.out.println("Transformed using " + eq + " and got: \n" + copy);
            TestTransform.assertTrue(copy.getDouble(0, 2) == 3.0);
            TestTransform.assertTrue(copy.getDouble(1, 2) == 9.0);
            TestTransform.assertTrue(copy.getDouble(2, 2) == 9.0);
            copy = new ColtDataSet(data);
            eq = "x = x + 3";
            Transformation.transform(copy, eq);
            System.out.println("Transformed using " + eq + " and got: \n" + copy);
            TestTransform.assertTrue(copy.getDouble(0, 0) == 5.0);
            TestTransform.assertTrue(copy.getDouble(1, 0) == 6.0);
            TestTransform.assertTrue(copy.getDouble(2, 0) == 7.0);
            copy = new ColtDataSet(data);
            eq = "x = pow(x, 2) + y + z";
            Transformation.transform(copy, eq);
            System.out.println("Transformed using " + eq + " and got: \n" + copy);
            TestTransform.assertTrue(copy.getDouble(0, 0) == 13.0);
            TestTransform.assertTrue(copy.getDouble(1, 0) == 23.0);
            TestTransform.assertTrue(copy.getDouble(2, 0) == 29.0);
        }
        catch (ParseException ex) {
            TestTransform.fail(ex.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(TestTransform.class);
    }
}

