/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator.expression;

import edu.cmu.tetradapp.model.calculator.expression.Context;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetradapp.model.calculator.expression.VariableExpression;
import java.util.Collections;
import java.util.List;

public class EvaluationExpression
implements Expression {
    static final long serialVersionUID = 23L;
    private VariableExpression variable;
    private String string;

    public EvaluationExpression(VariableExpression exp, String s) {
        if (exp == null) {
            throw new NullPointerException("Variable must not be null.");
        }
        if (s == null) {
            throw new NullPointerException("String must not be null.");
        }
        this.variable = exp;
        this.string = s;
    }

    public static EvaluationExpression serializableInstance() {
        return new EvaluationExpression(VariableExpression.serializableInstance(), "a");
    }

    @Override
    public double evaluate(Context context) {
        Double o = this.variable.evaluateGeneric(context);
        if (o != null && this.string.equals(((Object)o).toString())) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public String getToken() {
        return "Eval";
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return ExpressionDescriptor.Position.NEITHER;
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.singletonList(this.variable);
    }
}

