/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator.expression;

import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionDescriptor;
import java.util.List;

public class ExpressionUtils {
    public static String renderExpression(Expression expression, ExpressionDescriptor.Position position, String token) {
        List<Expression> expressions = expression.getExpressions();
        if (position == ExpressionDescriptor.Position.INFIX || position == ExpressionDescriptor.Position.BOTH && expressions.size() == 2) {
            Expression expression1 = expressions.get(0);
            Expression expression2 = expressions.get(1);
            ExpressionDescriptor.Position position1 = expression1.getPosition();
            ExpressionDescriptor.Position position2 = expression2.getPosition();
            StringBuilder buf = new StringBuilder();
            if (position1 == ExpressionDescriptor.Position.INFIX && !expression1.getToken().equals(token)) {
                buf.append("(");
                buf.append(expression1);
                buf.append(")");
            } else {
                buf.append(expression1);
            }
            buf.append(token);
            if (position2 == ExpressionDescriptor.Position.INFIX && !expression2.getToken().equals(token)) {
                buf.append("(");
                buf.append(expression2);
                buf.append(")");
            } else {
                buf.append(expression2);
            }
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(token);
        buf.append("(");
        for (int i = 0; i < expressions.size(); ++i) {
            buf.append(expressions.get(i));
            if (i >= expressions.size() - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }
}

