/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.datamanip.CovMatrixWrapper;

public class InvertCovMatrixWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public InvertCovMatrixWrapper(DataWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModel model = wrapper.getSelectedDataModel();
        if (!(model instanceof CovarianceMatrix)) {
            throw new IllegalArgumentException("Must be a covariance matrix");
        }
        CovarianceMatrix dataSet = (CovarianceMatrix)model;
        DoubleMatrix2D data = dataSet.getMatrix();
        DoubleMatrix2D inverse = MatrixUtils.inverse(data);
        String[] varNames = dataSet.getVariableNames().toArray(new String[0]);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), inverse, dataSet.getSampleSize());
        this.setDataModel(covarianceMatrix);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogObjectsUtils.logDataModelList("Inverts a parent covaraince matrix.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new CovMatrixWrapper(new DataWrapper(DataUtils.continuousSerializableInstance()));
    }
}

