/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class RemoveConstantColumnsDataFilter
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        int columns = dataSet.getNumColumns();
        int rows = dataSet.getNumRows();
        if (rows == 0) {
            return dataSet;
        }
        ArrayList<NodeWrapper> nodes = new ArrayList<NodeWrapper>(columns);
        for (int col = 0; col < columns; ++col) {
            Object previous = dataSet.getObject(0, col);
            boolean constant = true;
            for (int row = 1; row < rows; ++row) {
                Object current = dataSet.getObject(row, col);
                if (previous.equals(current)) continue;
                constant = false;
                break;
            }
            if (constant) continue;
            nodes.add(new NodeWrapper(col, dataSet.getVariable(col)));
        }
        if (nodes.size() == columns) {
            return dataSet;
        }
        if (nodes.size() == 0) {
            return new ColtDataSet(0, new LinkedList<Node>());
        }
        ColtDataSet newDataSet = new ColtDataSet(rows, RemoveConstantColumnsDataFilter.getNodes(nodes));
        for (int k = 0; k < nodes.size(); ++k) {
            NodeWrapper node = (NodeWrapper)nodes.get(k);
            for (int i = 0; i < rows; ++i) {
                newDataSet.setObject(i, k, dataSet.getObject(i, node.column));
            }
        }
        return newDataSet;
    }

    private static List<Node> getNodes(List<NodeWrapper> wrappers) {
        ArrayList<Node> nodes = new ArrayList<Node>(wrappers.size());
        for (NodeWrapper wrapper : wrappers) {
            nodes.add(wrapper.node);
        }
        return nodes;
    }

    private static class NodeWrapper {
        private int column;
        private Node node;

        public NodeWrapper(int column, Node node) {
            this.column = column;
            this.node = node;
        }
    }
}

