/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.datamanip.TimeSeriesParams;

public class TimeSeriesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public TimeSeriesWrapper(DataWrapper data, TimeSeriesParams params) {
        DataModelList dataSets = data.getDataModelList();
        DataModelList timeSeriesDataSets = new DataModelList();
        for (DataModel dataModel : dataSets) {
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("Only tabular data sets can be converted to time lagged form.");
            }
            DataSet dataSet = (DataSet)dataModel;
            DataSet timeSeries = TimeSeriesUtils.createLagData(dataSet, params.getNumOfTimeLags());
            if (dataSet.getName() != null) {
                timeSeries.setName(dataSet.getName());
            }
            timeSeriesDataSets.add(timeSeries);
        }
        this.setDataModel(timeSeriesDataSets);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Expansion of parent data into lagged data.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new TimeSeriesWrapper(DataWrapper.serializableInstance(), TimeSeriesParams.serializableInstance());
    }
}

