/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import java.util.LinkedList;

public class GraphHistory {
    private LinkedList<Graph> graphs = new LinkedList();
    private int index = -1;

    public void add(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        for (int i = this.graphs.size() - 1; i > this.index; --i) {
            this.graphs.remove(i);
        }
        this.graphs.addLast(new EdgeListGraph(graph));
        ++this.index;
    }

    public Graph next() {
        if (this.index == -1) {
            throw new IllegalArgumentException("Graph history has not been initialized yet.");
        }
        if (this.index < this.graphs.size() - 1) {
            ++this.index;
        }
        return this.graphs.get(this.index);
    }

    public Graph previous() {
        if (this.index == -1) {
            throw new IllegalArgumentException("Graph history has not been initialized yet.");
        }
        if (this.index > 0) {
            --this.index;
        }
        return this.graphs.get(this.index);
    }

    public void clear() {
        this.graphs.clear();
        this.index = -1;
    }
}

