/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.graph.Graph;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.rmi.MarshalledObject;

public class LayoutSelection
implements Transferable {
    private Graph layoutGraph;
    private DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(LayoutSelection.class, "Layout")};

    public LayoutSelection(Graph layoutGraph) {
        Graph result;
        if (layoutGraph == null) {
            throw new NullPointerException("Layout graph must not be null.");
        }
        try {
            result = new MarshalledObject<Graph>(layoutGraph).get();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new IllegalStateException("Could not clone.");
        }
        this.layoutGraph = result;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.layoutGraph;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.getTransferDataFlavors()[0]);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }
}

