/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.util.InternalClipboard;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutSelection;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PasteLayoutAction
extends AbstractAction
implements ClipboardOwner {
    private LayoutEditable layoutEditable;

    public PasteLayoutAction(LayoutEditable layoutEditable) {
        super("Paste Layout");
        if (layoutEditable == null) {
            throw new NullPointerException();
        }
        this.layoutEditable = layoutEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transferable transferable = InternalClipboard.getInstance().getContents(null);
        if (!(transferable instanceof LayoutSelection)) {
            return;
        }
        LayoutSelection selection = (LayoutSelection)transferable;
        DataFlavor flavor = new DataFlavor(LayoutSelection.class, "Layout");
        try {
            Graph layoutGrpah = (Graph)selection.getTransferData(flavor);
            if (layoutGrpah != null) {
                this.layoutEditable.layoutByGraph(layoutGrpah);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

