/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public final class StringTextField
extends JTextField {
    private String value;
    private Filter filter;

    public StringTextField(String value, int size) {
        super(size);
        this.setHorizontalAlignment(2);
        this.setValue(value);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringTextField.this.setValue(e.getActionCommand());
                }
                catch (NumberFormatException e1) {
                    StringTextField.this.setValue(StringTextField.this.value);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (StringTextField.this.isEditable()) {
                    StringTextField.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                StringTextField.this.setCaretPosition(0);
                StringTextField.this.moveCaretPosition(0);
                StringTextField.this.setValue(StringTextField.this.getText());
            }
        });
    }

    public void setValue(String value) {
        if (value.equals(this.value)) {
            return;
        }
        String newValue = this.filter(value, this.value);
        if (!newValue.equals(this.value)) {
            this.value = newValue;
            this.setText(this.value);
            this.firePropertyChange("newValue", null, this.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private String filter(String value, String oldValue) {
        if (this.filter == null) {
            return value;
        }
        return this.filter.filter(value, oldValue);
    }

    public static interface Filter {
        public String filter(String var1, String var2);
    }
}

