/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.random.Beta;
import cern.jet.random.BreitWigner;
import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import edu.cmu.tetradapp.util.FileLoadingUtils;
import edu.cmu.tetradapp.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.text.Document;

public class TetradSerializableUtils {
    public static final Class[] safelySerializableTypes = new Class[]{String.class, Class.class, Date.class, Collection.class, Map.class, DoubleMatrix2D.class, Document.class, Normal.class, Uniform.class, BreitWigner.class, Beta.class, DoubleMatrix1D.class, Number.class};
    private final String serializableScope;
    private final String currentDirectory;
    private final String archiveDirectory;

    public TetradSerializableUtils(String serializableScope, String currentDirectory, String archiveDirectory) {
        if (serializableScope == null) {
            throw new NullPointerException();
        }
        if (currentDirectory == null) {
            throw new NullPointerException();
        }
        if (archiveDirectory == null) {
            throw new NullPointerException();
        }
        this.serializableScope = serializableScope;
        this.currentDirectory = currentDirectory;
        this.archiveDirectory = archiveDirectory;
    }

    public void checkNestingOfFields() {
        List<Class> classes = this.getAssignableClasses(new File(this.getSerializableScope()), TetradSerializable.class);
        boolean foundUnsafeField = false;
        for (Class aClass : classes) {
            Field[] fields;
            Class clazz = aClass;
            if (TetradSerializableExcluded.class.isAssignableFrom(clazz)) continue;
            block1: for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                Class<?> type = field.getType();
                while (type.isArray()) {
                    type = type.getComponentType();
                }
                if (type.isPrimitive() || TetradSerializable.class.isAssignableFrom(type) && !TetradSerializableExcluded.class.isAssignableFrom(clazz)) continue;
                for (Class safelySerializableClass : safelySerializableTypes) {
                    if (safelySerializableClass.isAssignableFrom(type)) continue block1;
                }
                if (field.getName().equals("this$0")) continue;
                System.out.println("UNSAFE FIELD:" + field);
                foundUnsafeField = true;
            }
        }
        if (foundUnsafeField) {
            throw new RuntimeException("Unsafe serializable fields found. Please fix immediately.");
        }
    }

    public void serializeCurrentDirectory() throws RuntimeException {
        this.clearCurrentDirectory();
        TreeMap<String, List<String>> classFields = new TreeMap<String, List<String>>();
        List<Class> classes = this.getAssignableClasses(new File(this.getSerializableScope()), TetradSerializable.class);
        System.out.println("Serializing exemplars of instantiable TetradSerializable in " + this.getSerializableScope() + ".");
        System.out.println("Writing serialized examplars to " + this.getCurrentDirectory());
        int index = -1;
        for (Class aClass : classes) {
            Class clazz = aClass;
            if (TetradSerializableExcluded.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            int numFields = this.getNumNonSerialVersionUIDFields(clazz);
            if (numFields > 0 && this.serializableInstanceMethod(clazz) == null) {
                throw new RuntimeException("Class " + clazz + " does not " + "\nhave a public static serializableInstance constructor.");
            }
            if (++index % 50 == 0) {
                System.out.println(index);
            }
            System.out.print(".");
            this.serializeClass(clazz, classFields);
        }
        try {
            File file = new File(this.getCurrentDirectory(), "class_fields.ser");
            FileOutputStream out = new FileOutputStream(file);
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(classFields);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\nFinished serializing exemplars.");
    }

    private int getNumNonSerialVersionUIDFields(Class clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        int numFields = declaredFields.length;
        List<Field> fieldList = Arrays.asList(declaredFields);
        for (Field field : fieldList) {
            if (field.getName().equals("serialVersionUID")) {
                --numFields;
            }
            if (!field.getName().equals("this$0")) continue;
            --numFields;
        }
        return numFields;
    }

    public void clearCurrentDirectory() {
        File directory = new File(this.getCurrentDirectory());
        if (directory.exists() && directory.isDirectory()) {
            String[] listing;
            for (String aListing : listing = directory.list()) {
                File file = new File(this.getCurrentDirectory(), aListing);
                file.delete();
            }
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public void clearArchiveDirectory() {
        File directory = new File(this.getArchiveDirectory());
        if (directory.exists() && directory.isDirectory()) {
            String[] listing;
            for (String aListing : listing = directory.list()) {
                File file = new File(this.getArchiveDirectory(), aListing);
                file.delete();
            }
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private void serializeClass(Class clazz, Map<String, List<String>> classFields) throws RuntimeException {
        File current = new File(this.getCurrentDirectory());
        if (!current.exists() || !current.isDirectory()) {
            throw new IllegalStateException("There is no " + current.getAbsolutePath() + " directory. " + "\nThis is where the serialized classes should be. " + "Please run serializeCurrentDirectory() first.");
        }
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            int modifiers = field.getModifiers();
            boolean _static = Modifier.isStatic(modifiers);
            boolean _final = Modifier.isFinal(modifiers);
            field.setAccessible(true);
            if (!_static || !_final || 23L != field.getLong(null)) {
                throw new RuntimeException("Class " + clazz + " does not define static final " + "long serialVersionUID = 23L");
            }
            int numFields = this.getNumNonSerialVersionUIDFields(clazz);
            if (numFields > 0) {
                Method method = clazz.getMethod("serializableInstance", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                File file = new File(current, clazz.getName() + ".ser");
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                ObjectOutputStream objOut = new ObjectOutputStream(out);
                objOut.writeObject(object);
                out.close();
            }
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
            String className = objectStreamClass.getName();
            ObjectStreamField[] fields = objectStreamClass.getFields();
            ArrayList<String> fieldList = new ArrayList<String>();
            for (ObjectStreamField objectStreamField : fields) {
                String fieldName = objectStreamField.getName();
                fieldList.add(fieldName);
            }
            classFields.put(className, fieldList);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("There is no static final long field 'serialVersionUID' in " + clazz + ". Please make one and set it " + "to 23L.");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class " + clazz + "does not " + "have a public static serializableInstance constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method serializableInstance() of class " + clazz + " is not public.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to statically call the serializableInstance() method of class " + clazz + ".", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create a new, writeable file in " + this.getCurrentDirectory() + " when trying to serialize " + clazz + ".", e);
        }
    }

    public void deserializeCurrentDirectory() throws RuntimeException {
        String[] listing;
        System.out.println("Deserializing files in " + this.getCurrentDirectory());
        File directory = new File(this.getCurrentDirectory());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("There is no " + directory + " directory.");
        }
        for (String aListing : listing = directory.list()) {
            if (!aListing.endsWith(".ser")) continue;
            File file = new File(this.getCurrentDirectory(), aListing);
            this.deserializeClass(file);
        }
        System.out.println("Finished deserializing classes in " + this.getCurrentDirectory() + ".");
    }

    public Object deserializeClass(File file) throws RuntimeException {
        try {
            FileInputStream in = new FileInputStream(file);
            ObjectInputStream objIn = new ObjectInputStream(in);
            Object o = objIn.readObject();
            in.close();
            return o;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("There is no class in the current API to deserialize the object in " + file + ". Perhaps the " + "class was renamed, moved to another package, or removed. " + "In any case, please put it back where it was.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("There was an I/O error associated with the process of deserializing the file " + file + ".", e);
        }
    }

    public void archiveCurrentDirectory() throws RuntimeException {
        System.out.println("Making zip archive of files in " + this.getCurrentDirectory() + ", putting it in " + this.getArchiveDirectory() + ".");
        File current = new File(this.getCurrentDirectory());
        if (!current.exists() || !current.isDirectory()) {
            throw new IllegalArgumentException("There is no " + current.getAbsolutePath() + " directory. " + "\nThis is where the serialized classes should be. " + "Please run serializeCurrentDirectory() first.");
        }
        File archive = new File(this.getArchiveDirectory());
        if (archive.exists() && !archive.isDirectory()) {
            throw new IllegalArgumentException("Output directory " + archive.getAbsolutePath() + " is not a directory.");
        }
        if (!archive.exists()) {
            archive.mkdirs();
        }
        String[] filenames = current.list();
        byte[] buf = new byte[1024];
        try {
            String version = Version.currentRepositoryVersion().toString();
            String outFilename = "serializedclasses-" + version + ".zip";
            File _file = new File(this.getArchiveDirectory(), outFilename);
            FileOutputStream fileOut = new FileOutputStream(_file);
            ZipOutputStream out = new ZipOutputStream(fileOut);
            for (String filename : filenames) {
                int len;
                File file = new File(current, filename);
                FileInputStream in = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(filename);
                entry.setSize(file.length());
                entry.setTime(file.lastModified());
                out.putNextEntry(entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
            System.out.println("Finished writing zip file " + outFilename + ".");
        }
        catch (IOException e) {
            throw new RuntimeException("There was an I/O error associated with the process of zipping up files in " + this.getCurrentDirectory() + ".", e);
        }
    }

    public void updateVersion() {
        try {
            Version nextVersion;
            File file = new File("project/resources/version");
            if (!file.exists()) {
                throw new RuntimeException("Please make a file project/resources/version with a version number the form a.b.c-d in it, where a, b, c, and d are integers.");
            }
            FileReader fileIn = new FileReader(file);
            BufferedReader bufIn = new BufferedReader(fileIn);
            String spec = bufIn.readLine();
            System.out.println("*** Old version was: " + spec);
            if (spec.matches("(\\d*)")) {
                spec = spec + ".0.0-0";
                nextVersion = new Version(spec).nextMajorVersion();
            } else if (spec.matches("(\\d*)\\.(\\d*)")) {
                spec = spec + ".0-0";
                nextVersion = new Version(spec).nextMinorVersion();
            } else if (spec.matches("(\\d*)\\.(\\d*)\\.(\\d*)")) {
                spec = spec + "-0";
                nextVersion = new Version(spec).nextMinorSubversion();
            } else {
                nextVersion = new Version(spec).nextIncrementalRelease();
            }
            bufIn.close();
            FileWriter fileOut = new FileWriter(file);
            PrintWriter printOut = new PrintWriter(fileOut);
            printOut.print(nextVersion);
            printOut.close();
            File file2 = new File("COPYRIGHT");
            String copyright = FileLoadingUtils.fromResources("/resources/copyright");
            copyright = copyright.replaceAll("VERSION", nextVersion.toString());
            FileWriter fileOut2 = new FileWriter(file2);
            PrintWriter printOut2 = new PrintWriter(fileOut2);
            printOut2.print(copyright);
            printOut2.close();
            System.out.println("*** New version is: " + nextVersion.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please correct the file project/resources/version \nso that it contains a version number of the form \na.b.c-d, where a, b, c, and a are integers. It should have \nbeen in CVS. Try doing cvs up or looking in an recent version \nof the repository in case someone removed it. This should be \nthe version of last published version of Tetrad.");
        }
    }

    public void deserializeArchivedVersions() throws RuntimeException {
        String[] listing;
        System.out.println("Deserializing archived instances in " + this.getArchiveDirectory() + ".");
        File archive = new File(this.getArchiveDirectory());
        if (!archive.exists() || !archive.isDirectory()) {
            return;
        }
        for (String archiveName : listing = archive.list()) {
            ObjectInputStream objectIn;
            if (!archiveName.endsWith(".zip")) continue;
            try {
                File file = new File(this.getArchiveDirectory(), archiveName);
                ZipFile zipFile = new ZipFile(file);
                ZipEntry entry = zipFile.getEntry("class_fields.ser");
                InputStream inputStream = zipFile.getInputStream(entry);
                objectIn = new ObjectInputStream(inputStream);
                Map classFields = (Map)objectIn.readObject();
                zipFile.close();
                for (String className : classFields.keySet()) {
                    List fieldNames = (List)classFields.get(className);
                    Class<?> clazz = Class.forName(className);
                    ObjectStreamClass streamClass = ObjectStreamClass.lookup(clazz);
                    if (streamClass == null) {
                        System.out.println();
                    }
                    for (String fieldName : fieldNames) {
                        assert (streamClass != null);
                        ObjectStreamField field = streamClass.getField(fieldName);
                        if (field != null) continue;
                        throw new RuntimeException("Field '" + fieldName + "' was dropped from class '" + className + "' as a serializable field! Please " + "put it back!!!" + "\nIt used to be in " + className + " in this archive: " + archiveName + ".");
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not read class_fields.ser in archive + " + archiveName + " .", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem reading archive" + archiveName + "; see cause.", e);
            }
            System.out.println("...Deserializing instances in " + archiveName + "...");
            ZipEntry zipEntry = null;
            try {
                File file = new File(this.getArchiveDirectory(), archiveName);
                FileInputStream in = new FileInputStream(file);
                ZipInputStream zipinputstream = new ZipInputStream(in);
                while ((zipEntry = zipinputstream.getNextEntry()) != null) {
                    if (!zipEntry.getName().endsWith(".ser")) continue;
                    objectIn = new ObjectInputStream(zipinputstream);
                    objectIn.readObject();
                    zipinputstream.closeEntry();
                }
                zipinputstream.close();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not read object zipped file " + zipEntry.getName() + " in archive " + archiveName + ". " + "Perhaps the class was renamed, moved to another package, or " + "removed. In any case, please put it back where it was.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem reading archive" + archiveName + "; see cause.", e);
            }
        }
        System.out.println("Finished deserializing archived instances.");
    }

    public Method serializableInstanceMethod(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (!"serializableInstance".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 0 || !Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    public List<Class> getAssignableClasses(File path, Class<TetradSerializable> clazz) {
        File[] files;
        if (!path.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + path);
        }
        LinkedList<Class> classes = new LinkedList<Class>();
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(this.getAssignableClasses(file, clazz));
                continue;
            }
            String packagePath = file.getPath();
            packagePath = packagePath.replace('\\', '.');
            packagePath = packagePath.replace('/', '.');
            int index = (packagePath = packagePath.substring(packagePath.indexOf("edu.cmu"), packagePath.length())).indexOf(".class");
            if (index == -1) continue;
            packagePath = packagePath.substring(0, index);
            try {
                Class<?> _clazz = this.getClass().getClassLoader().loadClass(packagePath);
                if (!clazz.isAssignableFrom(_clazz) || _clazz.isInterface()) continue;
                classes.add(_clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    public String getSerializableScope() {
        return this.serializableScope;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String getArchiveDirectory() {
        return this.archiveDirectory;
    }
}

