/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import edu.cmu.tetradapp.workbench.PointPair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class DisplayEdge
extends JComponent
implements IDisplayEdge {
    public static final int HALF_ANCHORED = 0;
    public static final int ANCHORED_UNSELECTED = 1;
    public static final int ANCHORED_SELECTED = 2;
    public static final int DIRECTED = 0;
    public static final int NONDIRECTED = 1;
    private static final int UNDIRECTED = 2;
    public static final int PARTIALLY_ORIENTED = 3;
    public static final int BIDIRECTED = 4;
    private Edge modelEdge;
    private int mode;
    private int type = 0;
    private DisplayNode node1;
    private DisplayNode node2;
    private Point mouseTrackPoint = new Point();
    private Point relativeMouseTrackPoint = new Point();
    private Polygon clickRegion;
    private boolean showAdjacenciesOnly = false;
    private double offset = 0.0;
    private PointPair connectedPoints;
    private Color lineColor = new Color(78, 117, 175);
    private Color selectedColor = new Color(221, 66, 32);
    private float strokeWidth = 1.0f;
    private final ComponentHandler compHandler = new ComponentHandler();
    private final PropertyChangeHandler propertyChangeHandler = new PropertyChangeHandler();

    public DisplayEdge(DisplayNode node1, DisplayNode node2, int type) {
        if (node1 == null) {
            throw new NullPointerException("Node1 must not be null.");
        }
        if (node2 == null) {
            throw new NullPointerException("Node2 must not be null.");
        }
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("Type must be one of DIRECTED, NONDIRECTED, UNDIRECTED, PARTIALLY_ORIENTED,  or BIDIRECTED.");
        }
        this.node1 = node1;
        this.node2 = node2;
        this.type = type;
        this.mode = 1;
        node1.addComponentListener(this.compHandler);
        node2.addComponentListener(this.compHandler);
        node1.addPropertyChangeListener(this.propertyChangeHandler);
        node2.addPropertyChangeListener(this.propertyChangeHandler);
        this.resetBounds();
    }

    public DisplayEdge(Edge modelEdge, DisplayNode node1, DisplayNode node2) {
        if (modelEdge == null) {
            throw new NullPointerException("Model edge must not be null.");
        }
        if (node1 == null) {
            throw new NullPointerException("Node1 must not be null.");
        }
        if (node2 == null) {
            throw new NullPointerException("Node2 must not be null.");
        }
        this.modelEdge = modelEdge;
        this.node1 = node1;
        this.node2 = node2;
        this.mode = 1;
        node1.addComponentListener(this.compHandler);
        node2.addComponentListener(this.compHandler);
        node1.addPropertyChangeListener(this.propertyChangeHandler);
        node2.addPropertyChangeListener(this.propertyChangeHandler);
        this.resetBounds();
    }

    public DisplayEdge(DisplayNode node1, Point mouseTrackPoint, int type) {
        if (node1 == null) {
            throw new NullPointerException("Node1 must not be null.");
        }
        if (mouseTrackPoint == null) {
            throw new NullPointerException("Mouse track point must not be null.");
        }
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("Type must be one of DIRECTED, NONDIRECTED, UNDIRECTED, PARTIALLY_ORIENTED,  or BIDIRECTED.");
        }
        this.node1 = node1;
        this.mouseTrackPoint = mouseTrackPoint;
        this.type = type;
        this.mode = 0;
        this.resetBounds();
    }

    @Override
    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                g.setColor(this.getLineColor());
                Point point = this.getRelativeMouseTrackPoint();
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), point));
                if (this.getConnectedPoints() == null) break;
                this.drawEdge(g);
                break;
            }
            case 1: {
                g.setColor(this.getLineColor());
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), this.getNode2()));
                if (this.getConnectedPoints() == null) break;
                this.drawEdge(g);
                break;
            }
            case 2: {
                g.setColor(this.getSelectedColor());
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), this.getNode2()));
                if (this.getConnectedPoints() == null) break;
                this.drawEdge(g);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void drawEdge(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.getConnectedPoints().getFrom().translate(-this.getLocation().x, -this.getLocation().y);
        this.getConnectedPoints().getTo().translate(-this.getLocation().x, -this.getLocation().y);
        this.setClickRegion(null);
        int x1 = this.getConnectedPoints().getFrom().x;
        int y1 = this.getConnectedPoints().getFrom().y;
        int x2 = this.getConnectedPoints().getTo().x;
        int y2 = this.getConnectedPoints().getTo().y;
        g2d.setStroke(new BasicStroke(this.getStrokeWidth() + 1.0E-6f));
        g2d.drawLine(x1, y1, x2, y2);
        if (!this.isShowAdjacenciesOnly()) {
            this.drawEndpoints(this.getConnectedPoints(), g);
        }
        this.firePropertyChange("newPointPair", null, this.getConnectedPoints());
    }

    @Override
    public boolean contains(int x, int y) {
        Polygon clickRegion = this.getClickRegion();
        if (clickRegion != null) {
            return clickRegion.contains(new Point(x, y));
        }
        return false;
    }

    public Polygon getClickRegion() {
        if (this.clickRegion == null && this.getConnectedPoints() != null) {
            this.clickRegion = this.getSleeve(this.getConnectedPoints());
        }
        return this.clickRegion;
    }

    @Override
    public final PointPair getPointPair() {
        switch (this.mode) {
            case 0: {
                Point point = this.getRelativeMouseTrackPoint();
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), point));
                break;
            }
            case 1: 
            case 2: {
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), this.getNode2()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.getConnectedPoints();
    }

    @Override
    public final DisplayNode getComp1() {
        return this.getNode1();
    }

    @Override
    public final DisplayNode getComp2() {
        return this.getNode2();
    }

    public final int getMode() {
        return this.mode;
    }

    @Override
    public final Point getTrackPoint() {
        return this.mouseTrackPoint;
    }

    @Override
    public final boolean isSelected() {
        return this.mode == 2;
    }

    @Override
    public final void setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return;
        }
        boolean oldSelected = this.isSelected();
        if (this.mode != 0) {
            this.mode = selected ? 2 : 1;
            this.firePropertyChange("selected", oldSelected, selected);
            if (oldSelected != selected) {
                this.repaint();
            }
        }
    }

    @Override
    public void launchAssociatedEditor() {
    }

    @Override
    public final void toggleSelected() {
        this.setSelected(!this.isSelected());
    }

    @Override
    public final void updateTrackPoint(Point p) {
        if (this.mode != 0) {
            throw new IllegalStateException("Cannot call the updateTrackPoint method when the edge is not in HALF_ANCHORED mode.");
        }
        this.mouseTrackPoint = new Point(p);
        this.resetBounds();
        this.repaint();
    }

    @Override
    public final DisplayNode getNode1() {
        return this.node1;
    }

    @Override
    public final DisplayNode getNode2() {
        return this.node2;
    }

    @Override
    public final PointPair getConnectedPoints() {
        return this.connectedPoints;
    }

    @Override
    public final void setConnectedPoints(PointPair connectedPoints) {
        this.connectedPoints = connectedPoints;
    }

    @Override
    public final Point getRelativeMouseTrackPoint() {
        return this.relativeMouseTrackPoint;
    }

    public final void setClickRegion(Polygon clickRegion) {
        this.clickRegion = clickRegion;
    }

    protected final PointPair calculateEdge(DisplayNode comp1, DisplayNode comp2) {
        Rectangle r1 = comp1.getBounds();
        Rectangle r2 = comp2.getBounds();
        Point c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
        Point c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
        double angle = Math.atan2(c1.y - c2.y, c1.x - c2.x);
        Point d = new Point((int)(this.offset * Math.cos(angle += 1.5707963267948966)), (int)(this.offset * Math.sin(angle)));
        c1.translate(d.x, d.y);
        c2.translate(d.x, d.y);
        Point p1 = this.getBoundaryIntersection(comp1, c1, c2);
        Point p2 = this.getBoundaryIntersection(comp2, c2, c1);
        if (p1 == null || p2 == null) {
            c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
            c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
            p1 = this.getBoundaryIntersection(comp1, c1, c2);
            p2 = this.getBoundaryIntersection(comp2, c2, c1);
        }
        if (p1 == null || p2 == null) {
            return null;
        }
        return new PointPair(p1, p2);
    }

    protected final PointPair calculateEdge(DisplayNode comp, Point p) {
        Rectangle r = comp.getBounds();
        Point p1 = new Point((int)((double)r.x + (double)r.width / 2.0), (int)((double)r.y + (double)r.height / 2.0));
        Point p2 = new Point(p);
        p2.translate(this.getLocation().x, this.getLocation().y);
        Point p3 = this.getBoundaryIntersection(comp, p1, p2);
        return p3 == null ? null : new PointPair(p3, p2);
    }

    protected static double distance(Point p1, Point p2) {
        double d = (p1.x - p2.x) * (p1.x - p2.x);
        d += (double)((p1.y - p2.y) * (p1.y - p2.y));
        d = Math.sqrt(d);
        return d;
    }

    protected final void drawEndpoints(PointPair pp, Graphics g) {
        if (this.getModelEdge() != null) {
            Endpoint endpointA = this.getModelEdge().getEndpoint1();
            Endpoint endpointB = this.getModelEdge().getEndpoint2();
            if (endpointA == Endpoint.CIRCLE) {
                this.drawCircleEndpoint(pp.getTo(), pp.getFrom(), g);
            } else if (endpointA == Endpoint.ARROW) {
                this.drawArrowEndpoint(pp.getTo(), pp.getFrom(), g);
            }
            if (endpointB == Endpoint.CIRCLE) {
                this.drawCircleEndpoint(pp.getFrom(), pp.getTo(), g);
            } else if (endpointB == Endpoint.ARROW) {
                this.drawArrowEndpoint(pp.getFrom(), pp.getTo(), g);
            }
        } else {
            switch (this.type) {
                case 0: {
                    this.drawArrowEndpoint(pp.getFrom(), pp.getTo(), g);
                    break;
                }
                case 1: {
                    this.drawCircleEndpoint(pp.getTo(), pp.getFrom(), g);
                    this.drawCircleEndpoint(pp.getFrom(), pp.getTo(), g);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.drawCircleEndpoint(pp.getTo(), pp.getFrom(), g);
                    this.drawArrowEndpoint(pp.getFrom(), pp.getTo(), g);
                    break;
                }
                case 4: {
                    this.drawArrowEndpoint(pp.getFrom(), pp.getTo(), g);
                    this.drawArrowEndpoint(pp.getTo(), pp.getFrom(), g);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void drawArrowEndpoint(Point from, Point to, Graphics g) {
        double a = to.x - from.x;
        double b = from.y - to.y;
        double theta = Math.atan2(b, a);
        int itheta = (int)(theta * 360.0 / (Math.PI * 2) + 180.0);
        g.fillArc(to.x - 18, to.y - 18, 36, 36, itheta - 14 - 3 * (int)this.getStrokeWidth(), 29 + 6 * (int)this.getStrokeWidth());
    }

    private void drawCircleEndpoint(Point from, Point to, Graphics g) {
        int diameter = 12 + (int)this.getStrokeWidth();
        double a = to.x - from.x;
        double b = from.y - to.y;
        double theta = Math.atan2(b, a);
        int xminus = (int)(Math.cos(theta) * (double)diameter / 2.0);
        int yplus = (int)(Math.sin(theta) * (double)diameter / 2.0);
        g.fillOval(to.x - xminus - diameter / 2, to.y + yplus - diameter / 2, diameter, diameter);
        Color c = g.getColor();
        g.setColor(Color.white);
        g.fillOval(to.x - xminus - diameter / 4 - 1, to.y + yplus - diameter / 4 - 1, (int)((double)diameter / 1.4), (int)((double)diameter / 1.4));
        g.setColor(c);
    }

    private Point getBoundaryIntersection(DisplayNode comp, Point pIn, Point pOut) {
        Point loc = comp.getLocation();
        if (!comp.contains(pIn.x - loc.x, pIn.y - loc.y)) {
            return null;
        }
        if (comp.contains(pOut.x - loc.x, pOut.y - loc.y)) {
            return null;
        }
        Point pFrom = new Point(pOut);
        Point pTo = new Point(pIn);
        Point pMid = null;
        while (DisplayEdge.distance(pFrom, pTo) > 2.0) {
            pMid = new Point((pFrom.x + pTo.x) / 2, (pFrom.y + pTo.y) / 2);
            if (comp.contains(pMid.x - loc.x, pMid.y - loc.y)) {
                pTo = pMid;
                continue;
            }
            pFrom = pMid;
        }
        return pMid;
    }

    private Polygon getSleeve(PointPair pp) {
        if (pp == null || pp.getFrom() == null || pp.getTo() == null) {
            return null;
        }
        int d = (int)this.getStrokeWidth() + 6;
        if (Math.abs(pp.getFrom().y - pp.getTo().y) <= 3) {
            return DisplayEdge.getHorizSleeve(pp, d);
        }
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        double qx = pp.getTo().x - pp.getFrom().x;
        double qy = pp.getTo().y - pp.getFrom().y;
        double sx = (double)(d * d) / (1.0 + qx * qx / (qy * qy));
        sx = Math.pow(sx, 0.5);
        double sy = -(qx / qy) * sx;
        Point t = new Point((int)(sx += (double)pp.getFrom().x + 1.0) - pp.getFrom().x, (int)(sy += (double)pp.getFrom().y + 1.0) - pp.getFrom().y);
        xpoints[0] = pp.getFrom().x + t.x;
        xpoints[1] = pp.getTo().x + t.x;
        xpoints[2] = pp.getTo().x - t.x;
        xpoints[3] = pp.getFrom().x - t.x;
        ypoints[0] = pp.getFrom().y + t.y;
        ypoints[1] = pp.getTo().y + t.y;
        ypoints[2] = pp.getTo().y - t.y;
        ypoints[3] = pp.getFrom().y - t.y;
        return new Polygon(xpoints, ypoints, 4);
    }

    private static Polygon getHorizSleeve(PointPair pp, int halfWidth) {
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = pp.getFrom().x;
        xpoints[1] = pp.getFrom().x;
        xpoints[2] = pp.getTo().x;
        xpoints[3] = pp.getTo().x;
        ypoints[0] = pp.getFrom().y + halfWidth;
        ypoints[1] = pp.getFrom().y - halfWidth;
        ypoints[2] = pp.getTo().y - halfWidth;
        ypoints[3] = pp.getTo().y + halfWidth;
        return new Polygon(xpoints, ypoints, 4);
    }

    protected void resetBounds() {
        switch (this.mode) {
            case 0: {
                Rectangle temp = new Rectangle(this.mouseTrackPoint.x, this.mouseTrackPoint.y, 0, 0);
                this.setBounds(this.getNode1().getBounds().union(temp.getBounds()));
                this.relativeMouseTrackPoint = new Point(this.mouseTrackPoint);
                this.getRelativeMouseTrackPoint().translate(-this.getLocation().x, -this.getLocation().y);
                break;
            }
            case 1: 
            case 2: {
                Rectangle r1 = this.node1.getBounds();
                Rectangle r2 = this.node2.getBounds();
                Point c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
                Point c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
                double angle = Math.atan2(c1.y - c2.y, c1.x - c2.x);
                Point d = new Point((int)(this.offset * Math.cos(angle += 1.5707963267948966)), (int)(this.offset * Math.sin(angle)));
                r1.translate(d.x, d.y);
                r2.translate(d.x, d.y);
                this.setBounds(r1.getBounds().union(r2.getBounds()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private boolean isShowAdjacenciesOnly() {
        return this.showAdjacenciesOnly;
    }

    public final void setShowAdjacenciesOnly(boolean showAdjacenciesOnly) {
        this.showAdjacenciesOnly = showAdjacenciesOnly;
    }

    @Override
    public final Edge getModelEdge() {
        return this.modelEdge;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public Color getSelectedColor() {
        return this.selectedColor;
    }

    @Override
    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    @Override
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        if (strokeWidth < 0.0f) {
            throw new IllegalArgumentException("Stroke width must be at least 0.");
        }
        this.strokeWidth = strokeWidth;
    }

    final class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("selected".equals(name) && Boolean.FALSE.equals(evt.getNewValue())) {
                DisplayEdge.this.setSelected(false);
            }
        }
    }

    final class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public final void componentMoved(ComponentEvent e) {
            DisplayEdge.this.resetBounds();
            DisplayEdge.this.repaint();
        }

        @Override
        public final void componentResized(ComponentEvent e) {
            DisplayEdge.this.resetBounds();
            DisplayEdge.this.repaint();
        }
    }
}

