/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jdepend.framework.JavaClass;
import jdepend.framework.PackageFilter;
import jdepend.framework.ParserListener;

public abstract class AbstractParser {
    private ArrayList _parseListeners;
    private PackageFilter _filter;
    public static boolean DEBUG = false;

    public AbstractParser() {
        this(new PackageFilter());
    }

    public AbstractParser(PackageFilter packageFilter) {
        this._filter = packageFilter;
        this._parseListeners = new ArrayList();
    }

    public void addParseListener(ParserListener parserListener) {
        this._parseListeners.add(parserListener);
    }

    public abstract JavaClass parse(String var1) throws IOException;

    protected void onParsedJavaClass(JavaClass javaClass) {
        Iterator iterator = ((AbstractList)this._parseListeners).iterator();
        while (iterator.hasNext()) {
            ((ParserListener)iterator.next()).onParsedJavaClass(javaClass);
        }
    }

    protected PackageFilter getFilter() {
        if (this._filter == null) {
            this._filter = new PackageFilter();
        }
        return this._filter;
    }

    protected void debug(String string) {
        if (DEBUG) {
            System.err.println(string);
        }
    }
}

