/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileManager {
    private ArrayList _directories = new ArrayList();
    private ArrayList _files = new ArrayList();

    public void addDirectory(String string) throws IOException {
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("Invalid directory: " + string);
        }
        this._directories.add(file);
    }

    public static boolean acceptSourceFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return file.getName().endsWith(".java");
    }

    public static boolean acceptClassFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (file.getName().indexOf("$") > 0) {
            return false;
        }
        return file.getName().endsWith(".class");
    }

    public Collection extractFiles() {
        this._files.clear();
        Iterator iterator = ((AbstractList)this._directories).iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.extractFiles(file);
        }
        return this._files;
    }

    protected void extractFiles(File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (FileManager.acceptSourceFile(file2)) {
                File file3 = this.toClassFile(file2);
                if (FileManager.acceptClassFile(file3)) {
                    this.addFile(file3);
                } else {
                    this.addFile(file2);
                }
            } else if (FileManager.acceptClassFile(file2)) {
                this.addFile(file2);
            } else if (file2.isDirectory()) {
                this.extractFiles(file2);
            }
            ++n;
        }
    }

    protected void addFile(File file) {
        if (!this._files.contains(file)) {
            this._files.add(file);
        }
    }

    protected File toClassFile(File file) {
        String string = file.getPath();
        int n = string.indexOf(".java");
        if (n > 0) {
            string = string.substring(0, n) + ".class";
        }
        return new File(string);
    }
}

