/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import jdepend.framework.AbstractParser;
import jdepend.framework.DependencyConstraint;
import jdepend.framework.FileManager;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaClassFileParser;
import jdepend.framework.JavaPackage;
import jdepend.framework.JavaSourceFileParser;
import jdepend.framework.PackageFilter;
import jdepend.framework.ParserListener;

public class JDepend {
    private HashMap _packages;
    private FileManager _fileManager = new FileManager();
    private PackageFilter _filter;
    private AbstractParser _sourceParser;
    private AbstractParser _classParser;

    public JDepend() {
        this._packages = new HashMap();
        this._filter = new PackageFilter();
        this._sourceParser = new JavaSourceFileParser(this._filter);
        this._classParser = new JavaClassFileParser(this._filter);
    }

    public Collection analyze() {
        Collection collection = this._fileManager.extractFiles();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            try {
                JavaClass javaClass = this.parseClass(file);
                String string = javaClass.getPackageName();
                if (!this.getFilter().accept(string)) continue;
                JavaPackage javaPackage = this.addPackage(string);
                javaPackage.addClass(javaClass);
                Collection collection2 = javaClass.getImportedPackages();
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    JavaPackage javaPackage2 = (JavaPackage)iterator2.next();
                    javaPackage2 = this.addPackage(javaPackage2.getName());
                    javaPackage.dependsUpon(javaPackage2);
                }
            }
            catch (IOException iOException) {
                System.err.println("\n" + iOException.getMessage());
            }
        }
        return this.getPackages();
    }

    public void addDirectory(String string) throws IOException {
        this._fileManager.addDirectory(string);
    }

    public Collection getPackages() {
        return this._packages.values();
    }

    public JavaPackage getPackage(String string) {
        return (JavaPackage)this._packages.get(string);
    }

    public int countJavaPackages() {
        return this.getPackages().size();
    }

    public int countJavaClasses() {
        Collection collection = this._fileManager.extractFiles();
        return collection.size();
    }

    public boolean containsCycles() {
        Iterator iterator = this.getPackages().iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage = (JavaPackage)iterator.next();
            if (!javaPackage.containsCycle()) continue;
            return true;
        }
        return false;
    }

    public boolean dependencyMatch(DependencyConstraint dependencyConstraint) {
        return dependencyConstraint.match(this.getPackages());
    }

    public void addParseListener(ParserListener parserListener) {
        this._sourceParser.addParseListener(parserListener);
        this._classParser.addParseListener(parserListener);
    }

    protected JavaClass parseClass(File file) throws IOException {
        JavaClass javaClass = null;
        if (FileManager.acceptSourceFile(file)) {
            javaClass = this._sourceParser.parse(file.getPath());
        } else if (FileManager.acceptClassFile(file)) {
            javaClass = this._classParser.parse(file.getPath());
        } else {
            throw new IOException("File is not a .java or .class file: " + file.getPath());
        }
        return javaClass;
    }

    protected void setPackages(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage = (JavaPackage)iterator.next();
            this._packages.put(javaPackage.getName(), javaPackage);
        }
    }

    protected JavaPackage addPackage(String string) {
        JavaPackage javaPackage = (JavaPackage)this._packages.get(string);
        if (javaPackage == null) {
            javaPackage = new JavaPackage(string);
            this.addPackage(javaPackage);
        }
        return javaPackage;
    }

    protected void addPackage(JavaPackage javaPackage) {
        if (!this._packages.containsValue(javaPackage)) {
            this._packages.put(javaPackage.getName(), javaPackage);
        }
    }

    protected PackageFilter getFilter() {
        if (this._filter == null) {
            this._filter = new PackageFilter();
        }
        return this._filter;
    }
}

