/*
 * Decompiled with CFR 0.152.
 */
package jdepend.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;
import jdepend.framework.ParserListener;
import jdepend.swingui.AboutDialog;
import jdepend.swingui.AfferentNode;
import jdepend.swingui.DependTree;
import jdepend.swingui.DependTreeModel;
import jdepend.swingui.EfferentNode;
import jdepend.swingui.PackageNode;
import jdepend.swingui.StatusPanel;

public class JDepend
implements ParserListener {
    private jdepend.framework.JDepend _analyzer = new jdepend.framework.JDepend();
    private JFrame _frame;
    private StatusPanel _statusPanel;
    private JTextField _statusField;
    private JProgressBar _progressBar;
    private DependTree _afferentTree;
    private DependTree _efferentTree;
    private Hashtable _resourceStrings;
    private Hashtable _actions;
    private static Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static Font BOLD_FONT = new Font("dialog", 1, 12);

    public JDepend() {
        this._analyzer.addParseListener(this);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._resourceStrings = new Hashtable();
        this._resourceStrings.put("menubar", "File");
        this._resourceStrings.put("File", "About Exit");
        this._actions = new Hashtable();
        this._actions.put("About", new AboutAction());
        this._actions.put("Exit", new ExitAction());
    }

    public void addDirectory(String string) throws IOException {
        this._analyzer.addDirectory(string);
    }

    public void analyze() {
        this.display();
        this.startProgressMonitor(this._analyzer.countJavaClasses());
        ArrayList arrayList = new ArrayList(this._analyzer.analyze());
        Collections.sort(arrayList, new PackageComparator(PackageComparator.byName()));
        this.stopProgressMonitor();
        this.updateTree(arrayList);
    }

    public void onParsedJavaClass(JavaClass javaClass) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDepend.this.getProgressBar().setValue(JDepend.this.getProgressBar().getValue() + 1);
            }
        });
    }

    protected void display() {
        this._frame = this.createUI();
        ((Component)this._frame).setVisible(true);
    }

    protected void updateTree(ArrayList arrayList) {
        JavaPackage javaPackage = new JavaPackage("root");
        javaPackage.setAfferents(arrayList);
        javaPackage.setEfferents(arrayList);
        AfferentNode afferentNode = new AfferentNode(null, javaPackage);
        this.getAfferentTree().setModel(new DependTreeModel(afferentNode));
        EfferentNode efferentNode = new EfferentNode(null, javaPackage);
        this.getEfferentTree().setModel(new DependTreeModel(efferentNode));
    }

    protected void startProgressMonitor(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDepend.this.getProgressBar().setMinimum(0);
                JDepend.this.getProgressBar().setMaximum(n);
                JDepend.this.getStatusPanel().setStatusComponent(JDepend.this.getProgressBar());
            }
        });
    }

    protected void stopProgressMonitor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDepend.this.getStatusPanel().setStatusComponent(JDepend.this.getStatusField());
                int n = JDepend.this._analyzer.countJavaClasses();
                int n2 = JDepend.this._analyzer.countJavaPackages();
                JDepend.this.showStatusMessage("Analyzed " + n2 + " packages (" + n + " classes).");
            }
        });
    }

    protected JFrame createUI() {
        JFrame jFrame = this.createFrame("JDepend");
        JMenuBar jMenuBar = this.createMenubar();
        jFrame.setJMenuBar(jMenuBar);
        JPanel jPanel = this.createTreePanel();
        StatusPanel statusPanel = this.getStatusPanel();
        jFrame.getContentPane().add("Center", jPanel);
        jFrame.getContentPane().add("South", statusPanel);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 700;
        int n2 = 500;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        ((Component)jFrame).setBounds(n3, n4, n, n2);
        ((Component)jFrame).setSize(n, n2);
        return jFrame;
    }

    protected JFrame createFrame(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().setLayout(new BorderLayout());
        ((Component)jFrame).setBackground(SystemColor.control);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new ExitAction().actionPerformed(null);
            }
        });
        return jFrame;
    }

    protected JPanel createTreePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.getEfferentTree());
        jPanel.add(this.getAfferentTree());
        return jPanel;
    }

    protected StatusPanel createStatusPanel() {
        StatusPanel statusPanel = new StatusPanel();
        statusPanel.setStatusComponent(this.getStatusField());
        return statusPanel;
    }

    protected JProgressBar createProgressBar() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        return jProgressBar;
    }

    protected JTextField createStatusField() {
        JTextField jTextField = new JTextField();
        jTextField.setFont(BOLD_FONT);
        jTextField.setEditable(false);
        jTextField.setForeground(Color.black);
        jTextField.setBorder(BorderFactory.createBevelBorder(1));
        Insets insets = new Insets(5, 5, 5, 5);
        jTextField.setMargin(insets);
        return jTextField;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize((String)this._resourceStrings.get("menubar"));
        int n = 0;
        while (n < stringArray.length) {
            JMenu jMenu = this.createMenu(stringArray[n]);
            if (jMenu != null) {
                jMenuBar.add(jMenu);
            }
            ++n;
        }
        return jMenuBar;
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize((String)this._resourceStrings.get(string));
        JMenu jMenu = new JMenu(string);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = this.createMenuItem(stringArray[n]);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        char c = string.charAt(0);
        jMenu.setMnemonic(c);
        return jMenu;
    }

    protected JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        char c = string.charAt(0);
        jMenuItem.setMnemonic(c);
        char c2 = string.charAt(0);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)c2, 2));
        String string2 = string;
        jMenuItem.setActionCommand(string2);
        Action action = this.getActionForCommand(string2);
        if (action != null) {
            jMenuItem.addActionListener(action);
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    protected void showStatusMessage(String string) {
        this.getStatusField().setFont(BOLD_FONT);
        this.getStatusField().setForeground(Color.black);
        this.getStatusField().setText(" " + string);
    }

    protected void showStatusError(String string) {
        this.getStatusField().setFont(BOLD_FONT);
        this.getStatusField().setForeground(Color.red);
        this.getStatusField().setText(" " + string);
    }

    protected DependTree getAfferentTree() {
        if (this._afferentTree == null) {
            this._afferentTree = new DependTree();
            this._afferentTree.addTreeSelectionListener(new TreeListener());
        }
        return this._afferentTree;
    }

    protected DependTree getEfferentTree() {
        if (this._efferentTree == null) {
            this._efferentTree = new DependTree();
            this._efferentTree.addTreeSelectionListener(new TreeListener());
        }
        return this._efferentTree;
    }

    private StatusPanel getStatusPanel() {
        if (this._statusPanel == null) {
            this._statusPanel = this.createStatusPanel();
        }
        return this._statusPanel;
    }

    private JProgressBar getProgressBar() {
        if (this._progressBar == null) {
            this._progressBar = this.createProgressBar();
        }
        return this._progressBar;
    }

    private JTextField getStatusField() {
        if (this._statusField == null) {
            this._statusField = this.createStatusField();
        }
        return this._statusField;
    }

    private Action getActionForCommand(String string) {
        return (Action)this._actions.get(string);
    }

    private String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    private void postStatusMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDepend.this.showStatusMessage(string);
            }
        });
    }

    private void postStatusError(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDepend.this.showStatusError(string);
            }
        });
    }

    private void usage(String string) {
        if (string != null) {
            System.err.println("\n" + string);
        }
        String string2 = "\nJDepend ";
        System.err.println("");
        System.err.println("usage: ");
        System.err.println(string2 + "<directory> " + "[directory2 [directory 3] ...]");
        System.exit(1);
    }

    private void instanceMain(String[] stringArray) {
        if (stringArray.length < 1) {
            this.usage("Must specify at least one directory.");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("-")) {
                this.usage("Invalid argument: " + stringArray[n2]);
            }
            try {
                this.addDirectory(stringArray[n2]);
                ++n;
            }
            catch (IOException iOException) {
                this.usage("Directory does not exist: " + stringArray[n2]);
            }
            ++n2;
        }
        if (n == 0) {
            this.usage("Must specify at least one directory.");
        }
        this.analyze();
    }

    public static void main(String[] stringArray) {
        new JDepend().instanceMain(stringArray);
    }

    private class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDepend.this._frame.dispose();
            System.exit(0);
        }
    }

    private class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(JDepend.this._frame);
            aboutDialog.setModal(true);
            ((Component)aboutDialog).setLocation(300, 300);
            aboutDialog.show();
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        TreeListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath != null) {
                PackageNode packageNode = (PackageNode)treePath.getLastPathComponent();
                JDepend.this.showStatusMessage(packageNode.toMetricsString());
            }
        }
    }
}

