/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.LAPACKkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.nni.LAPACK;

class NNI_LAPACKkernel
implements LAPACKkernel {
    public NNI_LAPACKkernel() {
        LAPACK.init();
    }

    public int gbsv(int n, int kl, int ku, int nrhs, double[] Ab, int[] ipiv, double[] B) {
        int[] info = new int[1];
        LAPACK.gbsv(this.wrap(n), this.wrap(kl), this.wrap(ku), this.wrap(nrhs), Ab, this.ld(2 * kl + ku + 1), ipiv, B, this.ld(n), info);
        return info[0];
    }

    public int geev(LAPACKkernel.JobEig jobvl, LAPACKkernel.JobEig jobvr, int n, double[] A, double[] wr, double[] wi, double[] Vl, double[] Vr, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.geev(this.jobEig(jobvl), this.jobEig(jobvr), this.wrap(n), A, this.ld(n), wr, wi, Vl, this.ld(n), Vr, this.ld(n), work, this.wrap(lwork), info);
        return info[0];
    }

    public int gels(BLASkernel.Transpose trans, int m, int n, int nrhs, double[] A, double[] B, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.gels(this.trans(trans), this.wrap(m), this.wrap(n), this.wrap(nrhs), A, this.ld(m), B, this.ld(n, m), work, this.wrap(lwork), info);
        return info[0];
    }

    public int gesv(int n, int nrhs, double[] A, int[] ipiv, double[] B) {
        int[] info = new int[1];
        LAPACK.gesv(this.wrap(n), this.wrap(nrhs), A, this.ld(n), ipiv, B, this.ld(n), info);
        return info[0];
    }

    public int gtsv(int n, int nrhs, double[] dl, double[] d, double[] du, double[] B) {
        int[] info = new int[1];
        LAPACK.gtsv(this.wrap(n), this.wrap(nrhs), dl, d, du, B, this.ld(n), info);
        return info[0];
    }

    public int laenv(int ispec, String name, String opts, int n1, int n2, int n3, int n4) {
        return LAPACK.laenv(ispec, name.toCharArray(), opts.toCharArray(), n1, n2, n3, n4);
    }

    public double lamch(String cmach) {
        return LAPACK.lamch(cmach.toCharArray());
    }

    public int pbsv(BLASkernel.UpLo uplo, int n, int kd, int nrhs, double[] Ab, double[] B) {
        int[] info = new int[1];
        LAPACK.pbsv(this.uplo(uplo), this.wrap(n), this.wrap(kd), this.wrap(nrhs), Ab, this.ld(kd + 1), B, this.ld(n), info);
        return info[0];
    }

    public int pbtrf(BLASkernel.UpLo uplo, int n, int kd, double[] Ab) {
        int[] info = new int[1];
        LAPACK.pbtrf(this.uplo(uplo), this.wrap(n), this.wrap(kd), Ab, this.ld(kd + 1), info);
        return info[0];
    }

    public int pbtrs(BLASkernel.UpLo uplo, int n, int kd, int nrhs, double[] Ab, double[] B) {
        int[] info = new int[1];
        LAPACK.pbtrs(this.uplo(uplo), this.wrap(n), this.wrap(kd), this.wrap(nrhs), Ab, this.ld(kd + 1), B, this.ld(n), info);
        return info[0];
    }

    public int pbcon(BLASkernel.UpLo uplo, int n, int kd, double[] Ab, double anorm, double[] rcond, double[] work, int[] iwork) {
        int[] info = new int[1];
        LAPACK.pbcon(this.uplo(uplo), this.wrap(n), this.wrap(kd), Ab, this.ld(kd + 1), this.wrap(anorm), rcond, work, iwork, info);
        return info[0];
    }

    public int posv(BLASkernel.UpLo uplo, int n, int nrhs, double[] A, double[] B) {
        int[] info = new int[1];
        LAPACK.posv(this.uplo(uplo), this.wrap(n), this.wrap(nrhs), A, this.ld(n), B, this.ld(n), info);
        return info[0];
    }

    public int ppsv(BLASkernel.UpLo uplo, int n, int nrhs, double[] Ap2, double[] B) {
        int[] info = new int[1];
        LAPACK.ppsv(this.uplo(uplo), this.wrap(n), this.wrap(nrhs), Ap2, B, this.ld(n), info);
        return info[0];
    }

    public int pptrf(BLASkernel.UpLo uplo, int n, double[] Ap2) {
        int[] info = new int[1];
        LAPACK.pptrf(this.uplo(uplo), this.wrap(n), Ap2, info);
        return info[0];
    }

    public int pptrs(BLASkernel.UpLo uplo, int n, int nrhs, double[] Ap2, double[] B) {
        int[] info = new int[1];
        LAPACK.pptrs(this.uplo(uplo), this.wrap(n), this.wrap(nrhs), Ap2, B, this.ld(n), info);
        return info[0];
    }

    public int ppcon(BLASkernel.UpLo uplo, int n, double[] Ap2, double anorm, double[] rcond, double[] work, int[] iwork) {
        int[] info = new int[1];
        LAPACK.ppcon(this.uplo(uplo), this.wrap(n), Ap2, this.wrap(anorm), rcond, work, iwork, info);
        return info[0];
    }

    public int ptsv(int n, int nrhs, double[] d, double[] e, double[] B) {
        int[] info = new int[1];
        LAPACK.ptsv(this.wrap(n), this.wrap(nrhs), d, e, B, this.ld(n), info);
        return info[0];
    }

    public int sysv(BLASkernel.UpLo uplo, int n, int nrhs, double[] A, int[] ipiv, double[] B, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.sysv(this.uplo(uplo), this.wrap(n), this.wrap(nrhs), A, this.ld(n), ipiv, B, this.ld(n), work, this.wrap(lwork), info);
        return info[0];
    }

    public int spsv(BLASkernel.UpLo uplo, int n, int nrhs, double[] Ap2, int[] ipiv, double[] B) {
        int[] info = new int[1];
        LAPACK.spsv(this.uplo(uplo), this.wrap(n), this.wrap(nrhs), Ap2, ipiv, B, this.ld(n), info);
        return info[0];
    }

    public int syev(LAPACKkernel.JobEig jobz, BLASkernel.UpLo uplo, int n, double[] A, double[] w, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.syev(this.jobEig(jobz), this.uplo(uplo), this.wrap(n), A, this.ld(n), w, work, this.wrap(lwork), info);
        return info[0];
    }

    public int spev(LAPACKkernel.JobEig jobz, BLASkernel.UpLo uplo, int n, double[] Ap2, double[] w, double[] Z, double[] work) {
        int[] info = new int[1];
        LAPACK.spev(this.jobEig(jobz), this.uplo(uplo), this.wrap(n), Ap2, w, Z, this.ld(n), work, info);
        return info[0];
    }

    public int sbev(LAPACKkernel.JobEig jobz, BLASkernel.UpLo uplo, int n, int kd, double[] Ab, double[] w, double[] Z, double[] work) {
        int[] info = new int[1];
        LAPACK.sbev(this.jobEig(jobz), this.uplo(uplo), this.wrap(n), this.wrap(kd), Ab, this.ld(kd + 1), w, Z, this.ld(n), work, info);
        return info[0];
    }

    public int stev(LAPACKkernel.JobEig jobz, int n, double[] d, double[] e, double[] Z, double[] work) {
        int[] info = new int[1];
        LAPACK.stev(this.jobEig(jobz), this.wrap(n), d, e, Z, this.ld(n), work, info);
        return info[0];
    }

    public int gesvd(LAPACKkernel.JobSVD jobu, LAPACKkernel.JobSVD jobvt, int m, int n, double[] A, double[] s, double[] U, double[] Vt, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.gesvd(this.jobSVD(jobu), this.jobSVD(jobvt), this.wrap(m), this.wrap(n), A, this.ld(m), s, U, this.ld(m), Vt, this.ld(n), work, this.wrap(lwork), info);
        return info[0];
    }

    public int gesdd(LAPACKkernel.JobSVD jobz, int m, int n, double[] A, double[] s, double[] U, double[] Vt, double[] work, int lwork, int[] iwork) {
        int[] info = new int[1];
        LAPACK.gesdd(this.jobSVD(jobz), this.wrap(m), this.wrap(n), A, this.ld(m), s, U, this.ld(m), Vt, this.ld(n), work, this.wrap(lwork), iwork, info);
        return info[0];
    }

    public int gelss(int m, int n, int nrhs, double[] A, double[] B, double[] s, double rcond, int[] rank, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.gelss(this.wrap(m), this.wrap(n), this.wrap(nrhs), A, this.ld(m), B, this.ld(n, m), s, this.wrap(rcond), rank, work, this.wrap(lwork), info);
        return info[0];
    }

    public int gelsd(int m, int n, int nrhs, double[] A, double[] B, double[] s, double rcond, int[] rank, double[] work, int lwork, int[] iwork) {
        int[] info = new int[1];
        LAPACK.gelsd(this.wrap(m), this.wrap(n), this.wrap(nrhs), A, this.ld(m), B, this.ld(n, m), s, this.wrap(rcond), rank, work, this.wrap(lwork), iwork, info);
        return info[0];
    }

    private int[] wrap(int i) {
        return new int[]{i};
    }

    private double[] wrap(double d) {
        return new double[]{d};
    }

    private int[] ld(int n) {
        return this.wrap(Math.max(1, n));
    }

    private int[] ld(int m, int n) {
        return this.wrap(Math.max(1, Math.max(m, n)));
    }

    public int geqrf(int m, int n, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.geqrf(this.wrap(m), this.wrap(n), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int ormqr(BLASkernel.Side side, BLASkernel.Transpose trans, int m, int n, int k, double[] A, double[] tau, double[] C, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.ormqr(this.side(side), this.trans(trans), this.wrap(m), this.wrap(n), this.wrap(k), A, side == BLASkernel.Side.Left ? this.ld(m) : this.ld(n), tau, C, this.ld(m), work, this.wrap(lwork), info);
        return info[0];
    }

    public int orgqr(int m, int n, int k, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.orgqr(this.wrap(m), this.wrap(n), this.wrap(k), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int geqlf(int m, int n, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.geqlf(this.wrap(m), this.wrap(n), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int ormql(BLASkernel.Side side, BLASkernel.Transpose trans, int m, int n, int k, double[] A, double[] tau, double[] C, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.ormql(this.side(side), this.trans(trans), this.wrap(m), this.wrap(n), this.wrap(k), A, side == BLASkernel.Side.Left ? this.ld(m) : this.ld(n), tau, C, this.ld(m), work, this.wrap(lwork), info);
        return info[0];
    }

    public int orgql(int m, int n, int k, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.orgql(this.wrap(m), this.wrap(n), this.wrap(k), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int gerqf(int m, int n, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.gerqf(this.wrap(m), this.wrap(n), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int ormrq(BLASkernel.Side side, BLASkernel.Transpose trans, int m, int n, int k, double[] A, double[] tau, double[] C, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.ormrq(this.side(side), this.trans(trans), this.wrap(m), this.wrap(n), this.wrap(k), A, this.ld(k), tau, C, this.ld(m), work, this.wrap(lwork), info);
        return info[0];
    }

    public int orgrq(int m, int n, int k, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.orgrq(this.wrap(m), this.wrap(n), this.wrap(k), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int gelqf(int m, int n, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.gelqf(this.wrap(m), this.wrap(n), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int ormlq(BLASkernel.Side side, BLASkernel.Transpose trans, int m, int n, int k, double[] A, double[] tau, double[] C, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.ormlq(this.side(side), this.trans(trans), this.wrap(m), this.wrap(n), this.wrap(k), A, this.ld(k), tau, C, this.ld(m), work, this.wrap(lwork), info);
        return info[0];
    }

    public int orglq(int m, int n, int k, double[] A, double[] tau, double[] work, int lwork) {
        int[] info = new int[1];
        LAPACK.orglq(this.wrap(m), this.wrap(n), this.wrap(k), A, this.ld(m), tau, work, this.wrap(lwork), info);
        return info[0];
    }

    public int gbtrf(int m, int n, int kl, int ku, double[] Ab, int[] ipiv) {
        int[] info = new int[1];
        LAPACK.gbtrf(this.wrap(m), this.wrap(n), this.wrap(kl), this.wrap(ku), Ab, this.wrap(2 * kl + ku + 1), ipiv, info);
        return info[0];
    }

    public int gbtrs(BLASkernel.Transpose trans, int n, int kl, int ku, int nrhs, double[] Ab, int[] ipiv, double[] B) {
        int[] info = new int[1];
        LAPACK.gbtrs(this.trans(trans), this.wrap(n), this.wrap(kl), this.wrap(ku), this.wrap(nrhs), Ab, this.wrap(2 * kl + ku + 1), ipiv, B, this.ld(n), info);
        return info[0];
    }

    public int getrf(int m, int n, double[] A, int[] ipiv) {
        int[] info = new int[1];
        LAPACK.getrf(this.wrap(m), this.wrap(n), A, this.ld(m), ipiv, info);
        return info[0];
    }

    public int getrs(BLASkernel.Transpose trans, int n, int nrhs, double[] A, int[] ipiv, double[] B) {
        int[] info = new int[1];
        LAPACK.getrs(this.trans(trans), this.wrap(n), this.wrap(nrhs), A, this.ld(n), ipiv, B, this.ld(n), info);
        return info[0];
    }

    public int gecon(Matrix.Norm norm, int n, double[] A, double anorm, double[] rcond, double[] work, int[] iwork) {
        int[] info = new int[1];
        LAPACK.gecon(this.norm(norm), this.wrap(n), A, this.ld(n), this.wrap(anorm), rcond, work, iwork, info);
        return info[0];
    }

    public int gbcon(Matrix.Norm norm, int n, int kl, int ku, double[] Ab, int[] ipiv, double anorm, double[] rcond, double[] work, int[] iwork) {
        int[] info = new int[1];
        LAPACK.gbcon(this.norm(norm), this.wrap(n), this.wrap(kl), this.wrap(ku), Ab, this.ld(2 * kl + ku + 1), ipiv, this.wrap(anorm), rcond, work, iwork, info);
        return info[0];
    }

    public int gttrf(int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv) {
        int[] info = new int[1];
        LAPACK.gttrf(this.wrap(n), dl, d, du, du2, ipiv, info);
        return info[0];
    }

    public int gttrs(BLASkernel.Transpose trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] B) {
        int[] info = new int[1];
        LAPACK.gttrs(this.trans(trans), this.wrap(n), this.wrap(nrhs), dl, d, du, du2, ipiv, B, this.ld(n), info);
        return info[0];
    }

    public int gtcon(Matrix.Norm norm, int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double anorm, double[] rcond, double[] work, int[] iwork) {
        int[] info = new int[1];
        LAPACK.gtcon(this.norm(norm), this.wrap(n), dl, d, du, du2, ipiv, this.wrap(anorm), rcond, work, iwork, info);
        return info[0];
    }

    public int trtrs(BLASkernel.UpLo uplo, BLASkernel.Transpose trans, BLASkernel.Diag diag, int n, int nrhs, double[] A, int lda, double[] B) {
        int[] info = new int[1];
        LAPACK.trtrs(this.uplo(uplo), this.trans(trans), this.diag(diag), this.wrap(n), this.wrap(nrhs), A, this.wrap(lda), B, this.ld(n), info);
        return info[0];
    }

    public int tptrs(BLASkernel.UpLo uplo, BLASkernel.Transpose trans, BLASkernel.Diag diag, int n, int nrhs, double[] Ap2, double[] B) {
        int[] info = new int[1];
        LAPACK.tptrs(this.uplo(uplo), this.trans(trans), this.diag(diag), this.wrap(n), this.wrap(nrhs), Ap2, B, this.ld(n), info);
        return info[0];
    }

    public int tbtrs(BLASkernel.UpLo uplo, BLASkernel.Transpose trans, BLASkernel.Diag diag, int n, int kd, int nrhs, double[] Ab, double[] B) {
        int[] info = new int[1];
        LAPACK.tbtrs(this.uplo(uplo), this.trans(trans), this.diag(diag), this.wrap(n), this.wrap(kd), this.wrap(nrhs), Ab, this.wrap(kd + 1), B, this.ld(n), info);
        return info[0];
    }

    public int potrf(BLASkernel.UpLo uplo, int n, double[] A) {
        int[] info = new int[1];
        LAPACK.potrf(this.uplo(uplo), this.wrap(n), A, this.ld(n), info);
        return info[0];
    }

    public int potrs(BLASkernel.UpLo uplo, int n, int nrhs, double[] A, double[] B) {
        int[] info = new int[1];
        LAPACK.potrs(this.uplo(uplo), this.wrap(n), this.wrap(nrhs), A, this.ld(n), B, this.ld(n), info);
        return info[0];
    }

    public int pocon(BLASkernel.UpLo uplo, int n, double[] A, double anorm, double[] rcond, double[] work, int[] iwork) {
        int[] info = new int[1];
        LAPACK.pocon(this.uplo(uplo), this.wrap(n), A, this.ld(n), this.wrap(anorm), rcond, work, iwork, info);
        return info[0];
    }

    private char[] trans(BLASkernel.Transpose trans) {
        if (trans == BLASkernel.Transpose.NoTranspose) {
            return new char[]{'N'};
        }
        return new char[]{'T'};
    }

    private char[] side(BLASkernel.Side side) {
        if (side == BLASkernel.Side.Left) {
            return new char[]{'L'};
        }
        return new char[]{'R'};
    }

    private char[] uplo(BLASkernel.UpLo uplo) {
        if (uplo == BLASkernel.UpLo.Lower) {
            return new char[]{'L'};
        }
        return new char[]{'U'};
    }

    private char[] diag(BLASkernel.Diag diag) {
        if (diag == BLASkernel.Diag.NonUnit) {
            return new char[]{'N'};
        }
        return new char[]{'U'};
    }

    private char[] jobEig(LAPACKkernel.JobEig job) {
        if (job == LAPACKkernel.JobEig.Eigenvalues) {
            return new char[]{'N'};
        }
        return new char[]{'V'};
    }

    private char[] jobEigRange(LAPACKkernel.JobEigRange job) {
        if (job == LAPACKkernel.JobEigRange.All) {
            return new char[]{'A'};
        }
        if (job == LAPACKkernel.JobEigRange.Interval) {
            return new char[]{'V'};
        }
        return new char[]{'I'};
    }

    private char[] jobSVD(LAPACKkernel.JobSVD job) {
        if (job == LAPACKkernel.JobSVD.All) {
            return new char[]{'A'};
        }
        if (job == LAPACKkernel.JobSVD.Part) {
            return new char[]{'S'};
        }
        if (job == LAPACKkernel.JobSVD.Overwrite) {
            return new char[]{'O'};
        }
        return new char[]{'N'};
    }

    private char[] norm(Matrix.Norm norm) {
        if (norm == Matrix.Norm.One) {
            return new char[]{'1'};
        }
        if (norm == Matrix.Norm.Infinity) {
            return new char[]{'I'};
        }
        throw new IllegalArgumentException("Norm must be the 1 or the Infinity norm");
    }

    public int sbevd(LAPACKkernel.JobEig jobz, BLASkernel.UpLo uplo, int n, int kd, double[] Ab, double[] w, double[] Z, double[] work, int lwork, int[] iwork, int liwork) {
        int[] info = new int[1];
        LAPACK.sbevd(this.jobEig(jobz), this.uplo(uplo), this.wrap(n), this.wrap(kd), Ab, this.ld(kd + 1), w, Z, this.ld(n), work, this.wrap(lwork), iwork, this.wrap(liwork), info);
        return info[0];
    }

    public int spevd(LAPACKkernel.JobEig jobz, BLASkernel.UpLo uplo, int n, double[] Ap2, double[] w, double[] Z, double[] work, int lwork, int[] iwork, int liwork) {
        int[] info = new int[1];
        LAPACK.spevd(this.jobEig(jobz), this.uplo(uplo), this.wrap(n), Ap2, w, Z, this.ld(n), work, this.wrap(lwork), iwork, this.wrap(liwork), info);
        return info[0];
    }

    public int stevr(LAPACKkernel.JobEig jobz, LAPACKkernel.JobEigRange range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, int[] m, double[] w, double[] Z, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork) {
        int[] info = new int[1];
        LAPACK.stevr(this.jobEig(jobz), this.jobEigRange(range), this.wrap(n), d, e, this.wrap(vl), this.wrap(vu), this.wrap(il), this.wrap(iu), this.wrap(abstol), m, w, Z, this.ld(n), isuppz, work, this.wrap(lwork), iwork, this.wrap(liwork), info);
        return info[0];
    }

    public int syevr(LAPACKkernel.JobEig jobz, LAPACKkernel.JobEigRange range, BLASkernel.UpLo uplo, int n, double[] A, double vl, double vu, int il, int iu, double abstol, int[] m, double[] w, double[] Z, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork) {
        int[] info = new int[1];
        LAPACK.syevr(this.jobEig(jobz), this.jobEigRange(range), this.uplo(uplo), this.wrap(n), A, this.ld(n), this.wrap(vl), this.wrap(vu), this.wrap(il), this.wrap(iu), this.wrap(abstol), m, w, Z, this.ld(n), isuppz, work, this.wrap(lwork), iwork, this.wrap(liwork), info);
        return info[0];
    }
}

