/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

class CostBag {
    int gc = 0;
    int ge = 0;
    double substitutions = 0.0;

    public CostBag() {
    }

    public CostBag(int gc, int ge, double subs) {
        this.gc = gc;
        this.ge = ge;
        this.substitutions = subs;
    }

    public void add(CostBag bag) {
        this.gc += bag.gc;
        this.ge += bag.ge;
        this.substitutions += bag.substitutions;
    }

    public double score(double x, double y) {
        return this.substitutions + (double)this.gc * (x - y) + (double)this.ge * y;
    }

    public double approximateIntegral(double x1, double x2, double y1, double y2) {
        double dx = (x2 - x1) / 100.0;
        double dy = (y2 - y1) / 100.0;
        double total = 0.0;
        int count = 0;
        double x = x1;
        while (x <= x2) {
            double y = y1;
            while (y <= y2) {
                total += this.score(x, y);
                ++count;
                y += dy;
            }
            x += dx;
        }
        return (total /= (double)count) * (x2 - x1) * (y2 - y1);
    }
}

